/*
    This file is part of KDE.

    Copyright (C) 2007 Trolltech ASA. All rights reserved.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef SCALIX_H
#define SCALIX_H

#include <tdeio/job.h>
#include <tdeio/slavebase.h>

#include <tqobject.h>

class Scalix : public TQObject, public TDEIO::SlaveBase
{
  Q_OBJECT
  

  public:
    Scalix( const TQCString &protocol, const TQCString &pool, const TQCString &app );

    void get( const KURL &url );
    void put( const KURL &url, int permissions, bool overwrite, bool resume );

  private slots:
    void slotRetrieveResult( TDEIO::Job* );
    void slotPublishResult( TDEIO::Job* );
    void slotInfoMessage( TDEIO::Job*, const TQString& );

  private:
    void retrieveFreeBusy( const KURL& );
    void publishFreeBusy( const KURL& );

    TQString mFreeBusyData;
};

#endif
