/*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>
    Copyright (c) 2004 Till Adam <adam@kde.org>
    Copyright (c) 2005 Reinhold Kainhofer <reinhold@kainhofer.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KPIM_GROUPWAREDOWNLOADJOB_H
#define KPIM_GROUPWAREDOWNLOADJOB_H

#include "groupwareresourcejob.h"
#include <tqstringlist.h>

namespace TDEIO {
  class Job;
  class TransferJob;
}

namespace KPIM {

class GroupwareDataAdaptor;
class ProgressItem;

/**
  This class provides a resource for accessing a Groupware calendar with local caching.
*/
class GroupwareDownloadJob : public GroupwareJob
{
    Q_OBJECT
  
  public:
    GroupwareDownloadJob( GroupwareDataAdaptor *adaptor );

    void kill();

  protected:
    void listItems();
    void deleteIncidencesGoneFromServer();
    void downloadItem();

  protected slots:
    void run();

    void cancelLoad();

    void slotListItemsResult( TDEIO::Job * );
    void slotListItemsData( TDEIO::Job *, const TQByteArray & );
    void slotDownloadItemResult( TDEIO::Job * );
    void slotDownloadItemData( TDEIO::Job *, const TQByteArray & );
    
    void slotItemToDownload( const KURL &remoteURL,
                             KPIM::FolderLister::ContentType type );
    void slotItemOnServer( const KURL &remoteURL );
    void slotItemDownloaded( const TQString &localID, const KURL &remoteURL,
                             const TQString &fingerprint );
    void slotItemDownloadError( const KURL &remoteURL, const TQString &error );

  private:
    KURL::List mFoldersForDownload;
    /** mCurrentlyOnServer is the list of pathes of all items on the server.
        These pathes don't contain the server name! */
    KURL::List mCurrentlyOnServer;

    TQMap<KURL,KPIM::FolderLister::ContentType> mItemsForDownload;
    TQMap<KURL,KPIM::FolderLister::ContentType> mItemsDownloading;
    TQMap<KURL,KPIM::FolderLister::ContentType> mItemsDownloaded;
    TQMap<KURL,KPIM::FolderLister::ContentType> mItemsDownloadError;

    KPIM::ProgressItem *mProgress;

    TDEIO::TransferJob *mDownloadJob;
    TDEIO::TransferJob *mListEventsJob;
    
    TQString mListItemsData;
    TQString mDownloadItemsData;
};

}

#endif
