 /*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KCAL_RESOURCEGROUPWARE_H
#define KCAL_RESOURCEGROUPWARE_H

#include <libtdepim/progressmanager.h>

#include <libkcal/resourcecached.h>

#include <tdeabc/locknull.h>
#include <tdeio/job.h>
#include <tdeconfig.h>

namespace KPIM {
class GroupwarePrefsBase;
}

namespace KCal {

/**
  This class provides a resource for accessing a Groupware tdeioslave-based
  calendar.
*/
class ResourceGroupware : public ResourceCached
{
    Q_OBJECT
  
  public:
    ResourceGroupware();
  
    ResourceGroupware( const TDEConfig * );
    virtual ~ResourceGroupware();

    void readConfig( const TDEConfig *config );
    void writeConfig( TDEConfig *config );

    GroupwarePrefsBase *prefs();

    bool doOpen();
    void doClose();

    bool doLoad();
    bool doSave();

    TDEABC::Lock *lock();

  protected:
    void init();

    bool confirmSave();

  protected slots:
    void loadFinished();

    void slotJobResult( TDEIO::Job * );
    void slotJobData( TDEIO::Job *, const TQByteArray & );

    void cancelLoad();

  private:
    GroupwarePrefsBase *mPrefs;
    TDEABC::LockNull mLock;

    TDEIO::TransferJob *mDownloadJob;
    KPIM::ProgressItem *mProgress;
    TQString mJobData;

    bool mIsShowingError;
};

}

#endif
