/*
    This file is part of KOrganizer.
    Copyright (c) 2000,2001 Cornelius Schumacher <schumacher@kde.org>
    Copyright (C) 2003-2004 Reinhold Kainhofer <reinhold@kainhofer.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include <tqcursor.h>

#include <tdeactioncollection.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <kurl.h>

#include <libkcal/event.h>

#include "koglobals.h"

#include <korganizer/baseview.h>
#include "koeventpopupmenu.h"
#include "koeventpopupmenu.moc"
#include "kocorehelper.h"
#include "actionmanager.h"
#ifndef KORG_NOPRINTER
#include "calprinter.h"
#endif

KOEventPopupMenu::KOEventPopupMenu()
{
  mCalendar = 0;
  mCurrentIncidence = 0;
  mCurrentDate = TQDate();
  mHasAdditionalItems = false;

  insertItem( i18n("&Show"), this, TQT_SLOT( popupShow() ) );
  mEditOnlyItems.append(
    insertItem(i18n("&Edit..."), this, TQT_SLOT( popupEdit() ) ) );
#ifndef KORG_NOPRINTER
  insertItem( KOGlobals::self()->smallIcon("printer"), i18n("&Print..."),
              this, TQT_SLOT( print() ) );
#endif
  //------------------------------------------------------------------------
  mEditOnlyItems.append( insertSeparator() );
  mEditOnlyItems.append(
    insertItem( KOGlobals::self()->smallIcon("edit-cut"), i18n("&Cut"),
                this, TQT_SLOT( popupCut() ) ) );
  mEditOnlyItems.append(
    insertItem( KOGlobals::self()->smallIcon("edit-copy"), i18n("&Copy"),
                this, TQT_SLOT( popupCopy() ) ) );
  // paste is always possible
  insertItem( KOGlobals::self()->smallIcon("edit-paste"), i18n("&Paste"),
                this, TQT_SLOT( popupPaste() ) );
  mEditOnlyItems.append(
    insertItem( KOGlobals::self()->smallIcon("edit-delete"), i18n("&Delete"),
                this, TQT_SLOT( popupDelete() ) ) );
  //------------------------------------------------------------------------
  mEditOnlyItems.append( insertSeparator() );
  mEditOnlyItems.append(
    insertItem( KOGlobals::self()->smallIcon("bell"), i18n("&Toggle Reminder"),
                this, TQT_SLOT( popupAlarm() ) ) );
  //------------------------------------------------------------------------
  mRecurrenceItems.append( insertSeparator() );
  mRecurrenceItems.append(
    insertItem( i18n("&Dissociate This Occurrence"),
                this, TQT_SLOT( dissociateOccurrence() ) ) );
  mRecurrenceItems.append(
    insertItem( i18n("&Dissociate Future Occurrences"),
                this, TQT_SLOT( dissociateFutureOccurrence() ) ) );

  insertSeparator();
  insertItem( KOGlobals::self()->smallIcon("mail-forward"), i18n( "Send as iCalendar..."),
              this, TQT_SLOT(forward()) );
}

void KOEventPopupMenu::showIncidencePopup( Calendar *cal, Incidence *incidence, const TQDate &qd )
{
  mCalendar = cal;
  mCurrentIncidence = incidence;
  mCurrentDate = qd;

  if (mCurrentIncidence) {
    // Enable/Disabled menu items only valid for editable events.
    TQValueList<int>::Iterator it;
    for( it = mEditOnlyItems.begin(); it != mEditOnlyItems.end(); ++it ) {
      setItemEnabled(*it,!mCurrentIncidence->isReadOnly());
    }
    for ( it = mRecurrenceItems.begin(); it != mRecurrenceItems.end(); ++it ) {
      setItemVisible( *it, mCurrentIncidence->doesRecur() );
    }
    popup(TQCursor::pos());
  } else {
    kdDebug(5850) << "KOEventPopupMenu::showEventPopup(): No event selected" << endl;
  }
}

void KOEventPopupMenu::addAdditionalItem(const TQIconSet &icon,const TQString &text,
                                    const TQObject *receiver, const char *member,
                                    bool editOnly)
{
  if (!mHasAdditionalItems) {
    mHasAdditionalItems = true;
    insertSeparator();
  }
  int id = insertItem(icon,text,receiver,member);
  if (editOnly) mEditOnlyItems.append(id);
}

void KOEventPopupMenu::popupShow()
{
  if ( mCurrentIncidence ) {
    emit showIncidenceSignal( mCurrentIncidence, mCurrentDate );
  }
}

void KOEventPopupMenu::popupEdit()
{
  if ( mCurrentIncidence ) {
    emit editIncidenceSignal( mCurrentIncidence, mCurrentDate );
  }
}

void KOEventPopupMenu::print()
{
#ifndef KORG_NOPRINTER
  KOCoreHelper helper;
  CalPrinter printer( this, mCalendar, &helper );
  connect( this, TQT_SIGNAL(configChanged()), &printer, TQT_SLOT(updateConfig()) );

  Incidence::List selectedIncidences;
  selectedIncidences.append( mCurrentIncidence );

  printer.print( KOrg::CalPrinterBase::Incidence,
                 mCurrentDate, mCurrentDate, selectedIncidences );
#endif
}

void KOEventPopupMenu::popupDelete()
{
  if (mCurrentIncidence) emit deleteIncidenceSignal(mCurrentIncidence);
}

void KOEventPopupMenu::popupCut()
{
  if (mCurrentIncidence) emit cutIncidenceSignal(mCurrentIncidence);
}

void KOEventPopupMenu::popupCopy()
{
  if (mCurrentIncidence) emit copyIncidenceSignal(mCurrentIncidence);
}

void KOEventPopupMenu::popupPaste()
{
  emit pasteIncidenceSignal();
}


void KOEventPopupMenu::popupAlarm()
{
  if (mCurrentIncidence) emit toggleAlarmSignal( mCurrentIncidence );
}

void KOEventPopupMenu::dissociateOccurrence()
{
  if ( mCurrentIncidence )
    emit dissociateOccurrenceSignal( mCurrentIncidence, mCurrentDate );
}

void KOEventPopupMenu::dissociateFutureOccurrence()
{
  if ( mCurrentIncidence )
    emit dissociateFutureOccurrenceSignal( mCurrentIncidence, mCurrentDate );
}

void KOEventPopupMenu::forward()
{
  KOrg::MainWindow *w = ActionManager::findInstance( KURL() );
  if ( !w || !mCurrentIncidence )
    return;
  TDEActionCollection *ac = w->getActionCollection();
  TDEAction *action = ac->action( "schedule_forward" );
  action->activate();
}
