/*
    This file is part of KOrganizer.

    Copyright (c) 2003,2004 Cornelius Schumacher <schumacher@kde.org>
    Copyright (C) 2004 Reinhold Kainhofer <reinhold@kainhofer.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include "importdialog.h"

#include "koprefs.h"
#include "stdcalendar.h"

#include <tdelocale.h>

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqradiobutton.h>
#include <tqbuttongroup.h>

using namespace KCal;

ImportDialog::ImportDialog( const KURL &url, TQWidget *parent, bool isPart )
  : KDialogBase( Plain, i18n("Import Calendar/Event"), Ok | Cancel, Ok, parent,
                 0, true, true ),
    mUrl( url )
{
  TQFrame *topFrame = plainPage();
  TQVBoxLayout *topLayout = new TQVBoxLayout( topFrame, 0, spacingHint() );

  TQString txt = i18n("Import calendar/event at '%1' into KOrganizer.")
                .arg( mUrl.prettyURL() );

  topLayout->addWidget( new TQLabel( txt, topFrame ) );

  TQButtonGroup *radioBox = new TQButtonGroup( 1, Qt::Horizontal, topFrame );
  radioBox->setFlat( true );
  topLayout->addWidget( radioBox );

  mAddButton = new TQRadioButton( i18n("Add as new calendar"), radioBox );

  mMergeButton = new TQRadioButton( i18n("Merge into existing calendar"),
                                   radioBox );

  mOpenButton = isPart ? 0 : new TQRadioButton( i18n("Open in separate window"), radioBox );

  mAddButton->setChecked( true );
}

ImportDialog::~ImportDialog()
{
}

void ImportDialog::slotOk()
{
  kdDebug(5850) << "Adding resource for url '" << mUrl << "'" << endl;

  if ( mAddButton->isChecked() ) {
    emit addResource( mUrl );
  } else if ( mMergeButton->isChecked() ) {
    // emit a signal to action manager to merge mUrl into the current calendar
    emit openURL( mUrl, true );
  } else if ( mOpenButton && mOpenButton->isChecked() ) {
    // emit a signal to the action manager to open mUrl in a separate window
    emit newWindow( mUrl );
  } else {
    kdError() << "ImportDialog: internal error." << endl;
  }

  emit dialogFinished( this );
  accept();
}


#include "importdialog.moc"
