/*
    This file is part of Kontact.

    Copyright (c) 2003 Zack Rusin <zack@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include "knode_plugin.h"

#include "core.h"

#include <tdeapplication.h>
#include <tdeparts/componentfactory.h>
#include <kgenericfactory.h>
#include <tdeapplication.h>
#include <tdeaction.h>
#include <kiconloader.h>
#include <kdebug.h>

#include <dcopclient.h>

#include <tqwidget.h>


typedef KGenericFactory<KNodePlugin, Kontact::Core> KNodePluginFactory;
K_EXPORT_COMPONENT_FACTORY( libkontact_knodeplugin,
                            KNodePluginFactory( "kontact_knodeplugin" ) )


KNodePlugin::KNodePlugin( Kontact::Core *core, const char *, const TQStringList& )
  : Kontact::Plugin( core, TQT_TQOBJECT(core), "knode" ), mStub(0)
{
  setInstance( KNodePluginFactory::instance() );

  insertNewAction( new TDEAction( i18n( "New Article..." ), "mail-message-new", CTRL+SHIFT+Key_A,
                   this, TQT_SLOT( slotPostArticle() ), actionCollection(), "post_article" ) );

  mUniqueAppWatcher = new Kontact::UniqueAppWatcher(
      new Kontact::UniqueAppHandlerFactory<KNodeUniqueAppHandler>(), this );
}

KNodePlugin::~KNodePlugin()
{
}

bool KNodePlugin::createDCOPInterface( const TQString& /*serviceType*/ )
{
  return false;
}

bool KNodePlugin::isRunningStandalone()
{
  return mUniqueAppWatcher->isRunningStandalone();
}

TQStringList KNodePlugin::invisibleToolbarActions() const
{
  return TQStringList( "article_postNew" );
}

void KNodePlugin::slotPostArticle()
{
  (void) part(); // ensure part is loaded
  Q_ASSERT( mStub );
  if ( mStub )
    mStub->postArticle();
}

KParts::ReadOnlyPart* KNodePlugin::createPart()
{
  KParts::ReadOnlyPart *part = loadPart();
  if ( !part ) return 0;

  mStub = new KNodeIface_stub( dcopClient(), "knode", "KNodeIface" );
  return part;
}

////

#include "../../../knode/knode_options.h"
void KNodeUniqueAppHandler::loadCommandLineOptions()
{
    TDECmdLineArgs::addCmdLineOptions( knode_options );
}

int KNodeUniqueAppHandler::newInstance()
{
    // Ensure part is loaded
    (void)plugin()->part();
    DCOPRef knode( "knode", "KNodeIface" );
    DCOPReply reply = knode.call( "handleCommandLine" );
#if 0
    if ( reply.isValid() ) {
        bool handled = reply;
        kdDebug(5602) << k_funcinfo << "handled=" << handled << endl;
        if ( !handled )
#endif
    // in all cases, bring knode plugin to front
    return Kontact::UniqueAppHandler::newInstance();
#if 0
    }
    return 0;
#endif
}

#include "knode_plugin.moc"
