/*
    knglobals.h

    KNode, the KDE newsreader
    Copyright (c) 1999-2005 the KNode authors.
    See file AUTHORS for details

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, US
*/

#ifndef KNGLOBALS_H
#define KNGLOBALS_H

#include <tdeconfig.h>
#include "resource.h"

#include <kdemacros.h>

class TDEInstance;
class KNConfigManager;
class KNNetAccess;
class KNProgress;
class KNAccountManager;
class KNGroupManager;
class KNArticleManager;
class KNArticleFactory;
class KNFolderManager;
class TQWidget;
class KNFilterManager;
class KNMainWidget;
class KNScoringManager;
class KNMemoryManager;
class KXMLGUIClient;
namespace Kpgp {
   class Module;
}
namespace KNode {
  class ArticleWidget;
}


/** idea: Previously the manager classes were available
    via KNodeApp. Now they can be accessed directly,
    this removes many header dependencies.
    (knode.h isn't include everywhere) */
class KDE_EXPORT KNGlobals {
  public:
    KNGlobals();
    ~KNGlobals();

    /** topWidget == top, used for message boxes, */
    TQWidget               *topWidget;
    /** no need to include knode.h everywhere */
    KNMainWidget          *top;
    KXMLGUIClient         *guiClient;
    KNode::ArticleWidget  *artWidget;
    KNArticleFactory      *artFactory;
    Kpgp::Module          *pgp;
    TDEConfig               *config();
    TDEInstance             *instance;

    KNConfigManager       *configManager();
    KNNetAccess           *netAccess();
    KNAccountManager      *accountManager();
    KNGroupManager        *groupManager();
    KNArticleManager      *articleManager();
    KNFilterManager       *filterManager();
    KNFolderManager       *folderManager();
    KNScoringManager      *scoringManager();
    KNMemoryManager       *memoryManager();

    /** forwarded to top->setStatusMsg() if available */
    void setStatusMsg(const TQString& text = TQString(), int id = SB_MAIN);

private:
    TDESharedConfig::Ptr c_onfig;

    KNNetAccess           *mNetAccess;
    KNConfigManager       *mCfgManager;
    KNAccountManager      *mAccManager;
    KNGroupManager        *mGrpManager;
    KNArticleManager      *mArtManager;
    KNFilterManager       *mFilManager;
    KNFolderManager       *mFolManager;
    static KNScoringManager  *mScoreManager;
    KNMemoryManager       *mMemManager;
};


extern KNGlobals knGlobals KDE_EXPORT;

#endif
