/*
* KTray.
*
* This implements the functionality of the little icon in the kpanel
* tray. Among which are tool tips and the running clock animated icon
*
* Distributed under the GPL.
*/


// #include <tqkeycode.h>
// #include <tqlayout.h>
#include <tqpixmap.h>
#include <tqptrlist.h>
#include <tqstring.h>
#include <tqtimer.h>
#include <tqtooltip.h>

#include <tdeaction.h>            // actionPreferences()
#include <tdeglobal.h>
#include <tdeglobalsettings.h>
#include <kiconloader.h>        // UserIcon
#include <tdelocale.h>            // i18n
#include <tdepopupmenu.h>         // plug()
#include <ksystemtray.h>

#include "mainwindow.h"
#include "task.h"
#include "tray.h"

TQPtrVector<TQPixmap> *KarmTray::icons = 0;

KarmTray::KarmTray(MainWindow* parent)
  : KSystemTray(parent, "Karm Tray")
{
  // the timer that updates the "running" icon in the tray
  _taskActiveTimer = new TQTimer(this);
  connect( _taskActiveTimer, TQT_SIGNAL( timeout() ), this,
                             TQT_SLOT( advanceClock()) );

  if (icons == 0) {
    icons = new TQPtrVector<TQPixmap>(8);
    for (int i=0; i<8; i++) {
      TQPixmap *icon = new TQPixmap();
      TQString name;
      name.sprintf("active-icon-%d.xpm",i);
      *icon = UserIcon(name);
      icons->insert(i,icon);
    }
  }

  parent->actionPreferences->plug( contextMenu() ); 
  parent->actionStopAll->plug( contextMenu() );

  resetClock();
  initToolTip();

  // start of a kind of menu for the tray
  // this are experiments/tests
  /*
  for (int i=0; i<30; i++)
    _tray->insertTitle(i 18n("bla ").arg(i));
  for (int i=0; i<30; i++)
    _tray->insertTitle2(i 18n("bli ").arg(i));
  */
  // experimenting with menus for the tray
  /*
  trayPopupMenu = contextMenu();
  trayPopupMenu2 = new TQPopupMenu();
  trayPopupMenu->insertItem(i18n("Submenu"), *trayPopupMenu2);
  */
}

KarmTray::KarmTray(karmPart * parent)
  : KSystemTray( 0 , "Karm Tray")
{
// it is not convenient if every kpart gets an icon in the systray.
  _taskActiveTimer = 0;
}

KarmTray::~KarmTray()
{
}


// experiment
/*
void KarmTray::insertTitle(TQString title)
{
  trayPopupMenu->insertTitle(title);
}
*/

void KarmTray::startClock()
{
  if ( _taskActiveTimer ) 
  {
    _taskActiveTimer->start(1000);
    setPixmap( *(*icons)[_activeIcon] );
    show();
  }
}

void KarmTray::stopClock()
{
  if ( _taskActiveTimer )  
  {  
    _taskActiveTimer->stop();
    show();
  }
}

void KarmTray::advanceClock()
{
  _activeIcon = (_activeIcon+1) % 8;
  setPixmap( *(*icons)[_activeIcon]);
}

void KarmTray::resetClock()
{
  _activeIcon = 0;
  setPixmap( *(*icons)[_activeIcon]);
  show();
}

void KarmTray::initToolTip()
{
  updateToolTip(TQPtrList<Task> ());
}

void KarmTray::updateToolTip(TQPtrList<Task> activeTasks)
{
  if ( activeTasks.isEmpty() ) {
    TQToolTip::add( this, i18n("No active tasks") );
    return;
  }

  TQFontMetrics fm( TQToolTip::font() );
  const TQString continued = i18n( ", ..." );
  const int buffer = fm.boundingRect( continued ).width();
  const int desktopWidth = TDEGlobalSettings::desktopGeometry(this).width();
  const int maxWidth = desktopWidth - buffer;

  TQString qTip;
  TQString s;

  // Build the tool tip with all of the names of the active tasks.
  // If at any time the width of the tool tip is larger than the desktop,
  // stop building it.
  TQPtrListIterator<Task> item( activeTasks );
  for ( int i = 0; item.current(); ++item, ++i ) {
    Task* task = item.current();
    if ( i > 0 )
      s += i18n( ", " ) + task->name();
    else
      s += task->name();
    int width = fm.boundingRect( s ).width();
    if ( width > maxWidth ) {
      qTip += continued;
      break;
    }
    qTip = s;
  }

  TQToolTip::add( this, qTip );
}

#include "tray.moc"
