/*
    This file is part of Akregator.

    Copyright (C) 2005 Frank Osterfeld <frank.osterfeld@kdemail.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef AKREGATOR_BACKEND_STORAGEFACTORYREGISTRY_H
#define AKREGATOR_BACKEND_STORAGEFACTORYREGISTRY_H

#include "akregator_export.h"

class TQString;
class TQStringList;

namespace Akregator {
namespace Backend {

class StorageFactory;

class AKREGATOR_EXPORT StorageFactoryRegistry
{
    public:
        static StorageFactoryRegistry* self();

        ~StorageFactoryRegistry();
        
        bool registerFactory(StorageFactory* factory, const TQString& typestr);
        void unregisterFactory(const TQString& typestr);
        StorageFactory* getFactory(const TQString& typestr);
        bool containsFactory(const TQString& typestr) const;
        TQStringList list() const;
        

    private:
        static StorageFactoryRegistry* m_instance;
    
        StorageFactoryRegistry();
        StorageFactoryRegistry(const StorageFactoryRegistry&);
        StorageFactoryRegistry& operator=(const StorageFactoryRegistry&);

        class StorageFactoryRegistryPrivate;
        StorageFactoryRegistryPrivate* d;
};

}
}

#endif // STORAGEFACTORYREGISTRY_H
