#ifndef _MINIMAP_H
#define _MINIMAP_H

#include <tqwidget.h>
#include <tqframe.h>
#include <tqpixmap.h>
#include <tqgridview.h>
#include <tqtimer.h>

#include "gamecore.h"
#include "images.h"


class MiniMap : public TQGridView
{
    Q_OBJECT
  

    // Constructors
public:
    MiniMap( TQWidget *parent = 0, const char* name = 0 );
    virtual ~MiniMap();

    void setMap( Map *newMap );

protected:
    void paintCell( TQPainter *p, int row, int col );

private slots:
    void mapUpdate();

private:
    int SECTOR_HEIGHT;
    int SECTOR_WIDTH;

    int BOARD_HEIGHT;
    int BOARD_WIDTH;

    void drawSector( TQPainter *, Sector & );

    Map *map;
};


#endif // _MINIMAP_H_
