#include <tdeaction.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <kdebug.h>
#include <tdeversion.h>
#include <tdefiledialog.h>
#include <tdeglobal.h>
#include <tdeio/netaccess.h>
#include <tdelocale.h>
#include <tdemainwindow.h>
#include <kmimetype.h>
#include <tdemessagebox.h>
#include <kprinter.h>
#include <highscore/kscoredialog.h>
#include <kstandarddirs.h>
#include <kstatusbar.h>
#include <tdestdaccel.h>
#include <kstdaction.h>
#include <kstdgameaction.h>
#include <kstdguiitem.h>

#include <tqcolor.h>
#include <tqevent.h>
#include <tqfile.h>
#include <tqobject.h>
#include <tqmap.h>
#include <tqpoint.h>
#include <tqtimer.h>
#include <tqptrlist.h>
#include <tqpixmap.h>
#include <tqpixmapcache.h>
#include <tqfileinfo.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqlayout.h>
#include <tqwidget.h>

#include <stdlib.h>

#include "game.h"
#include "floater.h"
#include "slope.h"
#include "newgame.h"
#include "scoreboard.h"
#include "editor.h"
#include "pluginloader.h"
#include "printdialogpage.h"
#include "kolf.h"

Kolf::Kolf()
    : TDEMainWindow(0, "Kolf")
{
	competition = false;
	game = 0;
	editor = 0;
	spacer = 0;
	scoreboard = 0;
	isTutorial = false;

	initGUI();

	obj = new ObjectList;
	initPlugins();

	filename = TQString();
	dummy = new TQWidget(this);
	setCentralWidget(dummy);
	layout = new TQGridLayout(dummy, 3, 1);

	resize(420, 480);
}

Kolf::~Kolf()
{
	// wipe out our objects
	obj->setAutoDelete(true);
	delete obj;
}

void Kolf::initGUI()
{
	newAction = KStdGameAction::gameNew(TQT_TQOBJECT(this), TQT_SLOT(newGame()), actionCollection());
	newAction->setText(newAction->text() + TQString("..."));

	endAction = KStdGameAction::end(TQT_TQOBJECT(this), TQT_SLOT(closeGame()), actionCollection());
	printAction = KStdGameAction::print(TQT_TQOBJECT(this), TQT_SLOT(print()), actionCollection());

	(void) KStdGameAction::quit(TQT_TQOBJECT(this), TQT_SLOT(close()), actionCollection());
	saveAction = KStdAction::save(TQT_TQOBJECT(this), TQT_SLOT(save()), actionCollection(), "game_save");
	saveAction->setText(i18n("Save &Course"));
	saveAsAction = KStdAction::saveAs(TQT_TQOBJECT(this), TQT_SLOT(saveAs()), actionCollection(), "game_save_as");
	saveAsAction->setText(i18n("Save &Course As..."));

	saveGameAction = new TDEAction(i18n("&Save Game"), 0, TQT_TQOBJECT(this), TQT_SLOT(saveGame()), actionCollection(), "savegame");
	saveGameAsAction = new TDEAction(i18n("&Save Game As..."), 0, TQT_TQOBJECT(this), TQT_SLOT(saveGameAs()), actionCollection(), "savegameas");

	loadGameAction = KStdGameAction::load(TQT_TQOBJECT(this), TQT_SLOT(loadGame()), actionCollection());
	loadGameAction->setText(i18n("Load Saved Game..."));

	highScoreAction = KStdGameAction::highscores(TQT_TQOBJECT(this), TQT_SLOT(showHighScores()), actionCollection());

	editingAction = new TDEToggleAction(i18n("&Edit"), "pencil", CTRL+Key_E, TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "editing");
	newHoleAction = new TDEAction(i18n("&New"), "document-new", CTRL+SHIFT+Key_N, TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "newhole");
	clearHoleAction = new TDEAction(KStdGuiItem::clear().text(), "locationbar_erase", CTRL+Key_Delete, TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "clearhole");
	resetHoleAction = new TDEAction(i18n("&Reset"), CTRL+Key_R, TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "resethole");
	undoShotAction = KStdAction::undo(TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "undoshot");
	undoShotAction->setText(i18n("&Undo Shot"));
	//replayShotAction = new TDEAction(i18n("&Replay Shot"), 0, TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "replay");

	holeAction = new TDEListAction(i18n("Switch to Hole"), 0, TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "switchhole");
	nextAction = new TDEAction(i18n("&Next Hole"), "forward", TDEStdAccel::shortcut(TDEStdAccel::Forward), TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "nexthole");
	prevAction = new TDEAction(i18n("&Previous Hole"), "back", TDEStdAccel::shortcut(TDEStdAccel::Back), TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "prevhole");
	firstAction = new TDEAction(i18n("&First Hole"), "go-home", TDEStdAccel::shortcut(TDEStdAccel::Home), TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "firsthole");
	lastAction = new TDEAction(i18n("&Last Hole"), CTRL+SHIFT+Key_End, TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "lasthole");
	randAction = new TDEAction(i18n("&Random Hole"), "goto", 0, TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "randhole");

	useMouseAction = new TDEToggleAction(i18n("Enable &Mouse for Moving Putter"), 0, TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "usemouse");
	useMouseAction->setCheckedState(i18n("Disable &Mouse for Moving Putter"));
	connect(useMouseAction, TQT_SIGNAL(toggled(bool)), TQT_TQOBJECT(this), TQT_SLOT(useMouseChanged(bool)));
	TDEConfig *config = kapp->config();
	config->setGroup("Settings");
	useMouseAction->setChecked(config->readBoolEntry("useMouse", true));

	useAdvancedPuttingAction = new TDEToggleAction(i18n("Enable &Advanced Putting"), 0, TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "useadvancedputting");
	useAdvancedPuttingAction->setCheckedState(i18n("Disable &Advanced Putting"));
	connect(useAdvancedPuttingAction, TQT_SIGNAL(toggled(bool)), TQT_TQOBJECT(this), TQT_SLOT(useAdvancedPuttingChanged(bool)));
	useAdvancedPuttingAction->setChecked(config->readBoolEntry("useAdvancedPutting", false));

	showInfoAction = new TDEToggleAction(i18n("Show &Info"), "application-vnd.tde.info", CTRL+Key_I, TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "showinfo");
	showInfoAction->setCheckedState(i18n("Hide &Info"));
	connect(showInfoAction, TQT_SIGNAL(toggled(bool)), TQT_TQOBJECT(this), TQT_SLOT(showInfoChanged(bool)));
	showInfoAction->setChecked(config->readBoolEntry("showInfo", false));

	showGuideLineAction = new TDEToggleAction(i18n("Show Putter &Guideline"), 0, TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "showguideline");
	showGuideLineAction->setCheckedState(i18n("Hide Putter &Guideline"));
	connect(showGuideLineAction, TQT_SIGNAL(toggled(bool)), TQT_TQOBJECT(this), TQT_SLOT(showGuideLineChanged(bool)));
	showGuideLineAction->setChecked(config->readBoolEntry("showGuideLine", true));

	TDEToggleAction *act=new TDEToggleAction(i18n("Enable All Dialog Boxes"), 0, TQT_TQOBJECT(this), TQT_SLOT(enableAllMessages()), actionCollection(), "enableAll");
	act->setCheckedState(i18n("Disable All Dialog Boxes"));

	soundAction = new TDEToggleAction(i18n("Play &Sounds"), 0, TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "audio-x-generic");
	connect(soundAction, TQT_SIGNAL(toggled(bool)), TQT_TQOBJECT(this), TQT_SLOT(soundChanged(bool)));
	soundAction->setChecked(config->readBoolEntry("sound", true));

	(void) new TDEAction(i18n("&Reload Plugins"), 0, TQT_TQOBJECT(this), TQT_SLOT(initPlugins()), actionCollection(), "reloadplugins");
	(void) new TDEAction(i18n("Show &Plugins"), 0, TQT_TQOBJECT(this), TQT_SLOT(showPlugins()), actionCollection(), "showplugins");

	aboutAction = new TDEAction(i18n("&About Course"), 0, TQT_TQOBJECT(this), TQT_SLOT(emptySlot()), actionCollection(), "aboutcourse");
	tutorialAction = new TDEAction(i18n("&Tutorial"), 0, TQT_TQOBJECT(this), TQT_SLOT(tutorial()), actionCollection(), "tutorial");

	statusBar();
	setupGUI();
}

bool Kolf::queryClose()
{
	if (game)
		if (game->askSave(true))
			return false;
	return true;
}

void Kolf::startNewGame()
{
	NewGameDialog *dialog = 0;
	int firstHole = 1;

	if (loadedGame.isNull())
	{
		dialog = new NewGameDialog(filename.isNull(), dummy, "New Game Dialog");
		if (dialog->exec() != TQDialog::Accepted)
			goto end;
	}

	players.clear();
	delete scoreboard;
	scoreboard = new ScoreBoard(dummy, "Score Board");
	layout->addWidget(scoreboard, 1, 0);
	scoreboard->show();

	if (loadedGame.isNull())
	{
		PlayerEditor *curEditor = 0;
		int newId = 1;
		for (curEditor = dialog->players()->first(); curEditor; curEditor = dialog->players()->next(), ++newId)
		{
			players.append(Player());
			players.last().ball()->setColor(curEditor->color());
			players.last().setName(curEditor->name());
			players.last().setId(newId);
		}

		competition = dialog->competition();
		filename = filename.isNull()? dialog->course() : filename;
	}
	else
	{
		TDEConfig config(loadedGame);
		config.setGroup("0 Saved Game");

		if (isTutorial)
			filename = TDEGlobal::dirs()->findResource("appdata", "tutorial.kolf");
		else
			filename = config.readEntry("Course", TQString());

		if (filename.isNull())
			return;

		competition = config.readBoolEntry("Competition", false);
		firstHole = config.readNumEntry("Current Hole", 1);

		players.clear();
		KolfGame::scoresFromSaved(&config, players);
	}

	for (PlayerList::Iterator it = players.begin(); it != players.end(); ++it)
		scoreboard->newPlayer((*it).name());

	delete spacer;
	spacer = 0;
	delete game;
	game = new KolfGame(obj, &players, filename, dummy);
	game->setStrict(competition);

	connect(game, TQT_SIGNAL(newHole(int)), scoreboard, TQT_SLOT(newHole(int)));
	connect(game, TQT_SIGNAL(scoreChanged(int, int, int)), scoreboard, TQT_SLOT(setScore(int, int, int)));
	connect(game, TQT_SIGNAL(parChanged(int, int)), scoreboard, TQT_SLOT(parChanged(int, int)));
	connect(game, TQT_SIGNAL(modifiedChanged(bool)), TQT_TQOBJECT(this), TQT_SLOT(updateModified(bool)));
	connect(game, TQT_SIGNAL(newPlayersTurn(Player *)), TQT_TQOBJECT(this), TQT_SLOT(newPlayersTurn(Player *)));
	connect(game, TQT_SIGNAL(holesDone()), TQT_TQOBJECT(this), TQT_SLOT(gameOver()));
	connect(game, TQT_SIGNAL(checkEditing()), TQT_TQOBJECT(this), TQT_SLOT(checkEditing()));
	connect(game, TQT_SIGNAL(editingStarted()), TQT_TQOBJECT(this), TQT_SLOT(editingStarted()));
	connect(game, TQT_SIGNAL(editingEnded()), TQT_TQOBJECT(this), TQT_SLOT(editingEnded()));
	connect(game, TQT_SIGNAL(inPlayStart()), TQT_TQOBJECT(this), TQT_SLOT(inPlayStart()));
	connect(game, TQT_SIGNAL(inPlayEnd()), TQT_TQOBJECT(this), TQT_SLOT(inPlayEnd()));
	connect(game, TQT_SIGNAL(maxStrokesReached(const TQString &)), TQT_TQOBJECT(this), TQT_SLOT(maxStrokesReached(const TQString &)));
	connect(game, TQT_SIGNAL(largestHole(int)), TQT_TQOBJECT(this), TQT_SLOT(updateHoleMenu(int)));
	connect(game, TQT_SIGNAL(titleChanged(const TQString &)), TQT_TQOBJECT(this), TQT_SLOT(titleChanged(const TQString &)));
	connect(game, TQT_SIGNAL(newStatusText(const TQString &)), TQT_TQOBJECT(this), TQT_SLOT(newStatusText(const TQString &)));
	connect(game, TQT_SIGNAL(currentHole(int)), TQT_TQOBJECT(this), TQT_SLOT(setCurrentHole(int)));
	connect(holeAction, TQT_SIGNAL(activated(const TQString &)), game, TQT_SLOT(switchHole(const TQString &)));
	connect(nextAction, TQT_SIGNAL(activated()), game, TQT_SLOT(nextHole()));
	connect(prevAction, TQT_SIGNAL(activated()), game, TQT_SLOT(prevHole()));
	connect(firstAction, TQT_SIGNAL(activated()), game, TQT_SLOT(firstHole()));
	connect(lastAction, TQT_SIGNAL(activated()), game, TQT_SLOT(lastHole()));
	connect(randAction, TQT_SIGNAL(activated()), game, TQT_SLOT(randHole()));
	connect(editingAction, TQT_SIGNAL(activated()), game, TQT_SLOT(toggleEditMode()));
	connect(newHoleAction, TQT_SIGNAL(activated()), game, TQT_SLOT(addNewHole()));
	connect(clearHoleAction, TQT_SIGNAL(activated()), game, TQT_SLOT(clearHole()));
	connect(resetHoleAction, TQT_SIGNAL(activated()), game, TQT_SLOT(resetHole()));
	connect(undoShotAction, TQT_SIGNAL(activated()), game, TQT_SLOT(undoShot()));
	//connect(replayShotAction, TQT_SIGNAL(activated()), game, TQT_SLOT(replay()));
	connect(aboutAction, TQT_SIGNAL(activated()), game, TQT_SLOT(showInfoDlg()));
	connect(useMouseAction, TQT_SIGNAL(toggled(bool)), game, TQT_SLOT(setUseMouse(bool)));
	connect(useAdvancedPuttingAction, TQT_SIGNAL(toggled(bool)), game, TQT_SLOT(setUseAdvancedPutting(bool)));
	connect(soundAction, TQT_SIGNAL(toggled(bool)), game, TQT_SLOT(setSound(bool)));
	connect(showGuideLineAction, TQT_SIGNAL(toggled(bool)), game, TQT_SLOT(setShowGuideLine(bool)));
	connect(showInfoAction, TQT_SIGNAL(toggled(bool)), game, TQT_SLOT(setShowInfo(bool)));

	game->setUseMouse(useMouseAction->isChecked());
	game->setUseAdvancedPutting(useAdvancedPuttingAction->isChecked());
	game->setShowInfo(showInfoAction->isChecked());
	game->setShowGuideLine(showGuideLineAction->isChecked());
	game->setSound(soundAction->isChecked());

	layout->addWidget(game, 0, 0, AlignCenter);

	game->show();
	game->setFocus();

	setEditingEnabled(true);
	endAction->setEnabled(true);
	setHoleMovementEnabled(true);
	setHoleOtherEnabled(true);
	aboutAction->setEnabled(true);
	highScoreAction->setEnabled(true);
	printAction->setEnabled(true);
	saveAction->setEnabled(true);
	saveAsAction->setEnabled(true);
	saveGameAction->setEnabled(true);
	saveGameAsAction->setEnabled(true);

	clearHoleAction->setEnabled(false);
	newHoleAction->setEnabled(false);
	newAction->setEnabled(false);
	loadGameAction->setEnabled(false);
	tutorialAction->setEnabled(false);


	// so game can do stuff that needs to be done
	// after things above are connected
	game->startFirstHole(firstHole);

	end:
	delete dialog;
}

void Kolf::newGame()
{
	isTutorial = false;
	filename = TQString();
	startNewGame();
}

void Kolf::tutorial()
{
	TQString newfilename = TDEGlobal::dirs()->findResource("appdata", "tutorial.kolfgame");
	if (newfilename.isNull())
	        return;

	filename = TQString();
	loadedGame = newfilename;
	isTutorial = true;

	startNewGame();

	loadedGame = TQString();
}

void Kolf::closeGame()
{
	if (game)
	{
		if (game->askSave(true))
			return;
		game->pause();
	}

	filename = TQString();

	editingEnded();
	delete game;
	game = 0;
	loadedGame = TQString();

	editingAction->setChecked(false);
	setEditingEnabled(false);
	endAction->setEnabled(false);
	aboutAction->setEnabled(false);
	highScoreAction->setEnabled(false);
	printAction->setEnabled(false);
	saveAction->setEnabled(false);
	saveAsAction->setEnabled(false);
	saveGameAction->setEnabled(false);
	saveGameAsAction->setEnabled(false);
	setHoleMovementEnabled(false);
	setHoleOtherEnabled(false);

	clearHoleAction->setEnabled(false);
	newHoleAction->setEnabled(false);
	newAction->setEnabled(true);
	loadGameAction->setEnabled(true);
	tutorialAction->setEnabled(true);

	titleChanged(TQString());
	updateModified(false);

	TQTimer::singleShot(100, TQT_TQOBJECT(this), TQT_SLOT(createSpacer()));
}

void Kolf::createSpacer()
{
	// make a player to play the spacer hole
	spacerPlayers.clear();
	spacerPlayers.append(Player());
	spacerPlayers.last().ball()->setColor(yellow);
	spacerPlayers.last().setName("player");
	spacerPlayers.last().setId(1);

	delete spacer;
	spacer = new KolfGame(obj, &spacerPlayers, TDEGlobal::dirs()->findResource("appdata", "intro"), dummy);
	spacer->setSound(false);
	spacer->startFirstHole(1);
	layout->addWidget(spacer, 0, 0, AlignCenter);
	spacer->hidePutter();
	spacer->ignoreEvents(true);

	spacer->show();
}

void Kolf::gameOver()
{
	int curPar = 0;
	int lowScore = INT_MAX; // let's hope it doesn't stay this way!
	int curScore = 1;

	// names of people who had the lowest score
	TQStringList names;

	HighScoreList highScores;
	int scoreBoardIndex = 1;

	while (curScore != 0)
	{
		TQString curName;

		// name taken as a reference and filled out
		curScore = scoreboard->total(scoreBoardIndex, curName);

		scoreBoardIndex++;

		if (curName == i18n("Par"))
		{
			curPar = curScore;
			continue;
		}

		if (curScore == 0)
			continue;

		// attempt to add everybody to the highscore list
		// (ignored if we aren't competing down below)
		highScores.append(HighScore(curName, curScore));

		if (curScore < lowScore)
		{
			names.clear();
			lowScore = curScore;
			names.append(curName);
		}
		else if (curScore == lowScore)
			names.append(curName);
	}

	// only announce a winner if more than two entries
	// (player and par) are on the scoreboard + one to go past end
	// + 1 for koodoo
	if (scoreBoardIndex > 4)
	{
		if (names.count() > 1)
		{
			TQString winners = names.join(i18n(" and "));
			KMessageBox::information(this, i18n("%1 tied").arg(winners));
		}
		else
			KMessageBox::information(this, i18n("%1 won!").arg(names.first()));
	}

	if (competition)
	{
		// deal with highscores
		// KScoreDialog makes it very easy :-))

		KScoreDialog *scoreDialog = new KScoreDialog(KScoreDialog::Name | KScoreDialog::Custom1 | KScoreDialog::Score, this);
		scoreDialog->addField(KScoreDialog::Custom1, i18n("Par"), "Par");

		CourseInfo courseInfo;
		game->courseInfo(courseInfo, game->curFilename());

		scoreDialog->setConfigGroup(courseInfo.untranslatedName + TQString(" Highscores"));

		for (HighScoreList::Iterator it = highScores.begin(); it != highScores.end(); ++it)
		{
			KScoreDialog::FieldInfo info;
			info[KScoreDialog::Name] = (*it).name;
			info[KScoreDialog::Custom1] = TQString::number(curPar);

			scoreDialog->addScore((*it).score, info, false, true);
		}

		scoreDialog->setComment(i18n("High Scores for %1").arg(courseInfo.name));
		scoreDialog->show();
	}

	TQTimer::singleShot(700, TQT_TQOBJECT(this), TQT_SLOT(closeGame()));
}

void Kolf::showHighScores()
{
	KScoreDialog *scoreDialog = new KScoreDialog(KScoreDialog::Name | KScoreDialog::Custom1 | KScoreDialog::Score, this);
	scoreDialog->addField(KScoreDialog::Custom1, i18n("Par"), "Par");

	CourseInfo courseInfo;
	game->courseInfo(courseInfo, game->curFilename());

	scoreDialog->setConfigGroup(courseInfo.untranslatedName + TQString(" Highscores"));
	scoreDialog->setComment(i18n("High Scores for %1").arg(courseInfo.name));
	scoreDialog->show();
}

void Kolf::save()
{
	if (filename.isNull())
	{
		saveAs();
		return;
	}

	if (game)
		game->save();

	game->setFocus();
}

void Kolf::saveAs()
{
	TQString newfilename = KFileDialog::getSaveFileName(":kourses", "application/x-kourse", this, i18n("Pick Kolf Course to Save To"));
	if (!newfilename.isNull())
	{
		filename = newfilename;
		game->setFilename(filename);
		game->save();
		game->setFocus();
	}
}

void Kolf::saveGameAs()
{
	TQString newfilename = KFileDialog::getSaveFileName(":savedkolf", "application/x-kolf", this, i18n("Pick Saved Game to Save To"));
	if (newfilename.isNull())
		return;

	loadedGame = newfilename;

	saveGame();
}

void Kolf::saveGame()
{
	if (loadedGame.isNull())
	{
		saveGameAs();
		return;
	}

	TDEConfig config(loadedGame);
	config.setGroup("0 Saved Game");

	config.writeEntry("Competition", competition);
	config.writeEntry("Course", filename);

	game->saveScores(&config);

	config.sync();
}

void Kolf::loadGame()
{
	loadedGame = KFileDialog::getOpenFileName(":savedkolf", TQString::fromLatin1("application/x-kolf"), this, i18n("Pick Kolf Saved Game"));

	if (loadedGame.isNull())
		return;

	isTutorial = false;
	startNewGame();
}

// called by main for commmand line files
void Kolf::openURL(KURL url)
{
	TQString target;
	if (TDEIO::NetAccess::download(url, target, this))
	{
		isTutorial = false;
		TQString mimeType = KMimeType::findByPath(target)->name();
		if (mimeType == "application/x-kourse")
			filename = target;
		else if (mimeType == "application/x-kolf")
			loadedGame = target;
		else
		{
			closeGame();
			return;
		}

		TQTimer::singleShot(10, TQT_TQOBJECT(this), TQT_SLOT(startNewGame()));
	}
	else
		closeGame();
}

void Kolf::newPlayersTurn(Player *player)
{
	tempStatusBarText = i18n("%1's turn").arg(player->name());

	if (showInfoAction->isChecked())
		statusBar()->message(tempStatusBarText, 5 * 1000);
	else
		statusBar()->message(tempStatusBarText);

	scoreboard->setCurrentCell(player->id() - 1, game->currentHole() - 1);
}

void Kolf::newStatusText(const TQString &text)
{
	if (text.isEmpty())
		statusBar()->message(tempStatusBarText);
	else
		statusBar()->message(text);
}

void Kolf::editingStarted()
{
	delete editor;
	editor = new Editor(obj, dummy, "Editor");
	connect(editor, TQT_SIGNAL(addNewItem(Object *)), game, TQT_SLOT(addNewObject(Object *)));
	connect(editor, TQT_SIGNAL(changed()), game, TQT_SLOT(setModified()));
	connect(editor, TQT_SIGNAL(addNewItem(Object *)), TQT_TQOBJECT(this), TQT_SLOT(setHoleFocus()));
	connect(game, TQT_SIGNAL(newSelectedItem(CanvasItem *)), editor, TQT_SLOT(setItem(CanvasItem *)));

	scoreboard->hide();

	layout->addWidget(editor, 1, 0);
	editor->show();

	clearHoleAction->setEnabled(true);
	newHoleAction->setEnabled(true);
	setHoleOtherEnabled(false);

	game->setFocus();
}

void Kolf::editingEnded()
{
	delete editor;
	editor = 0;

	if (scoreboard)
		scoreboard->show();

	clearHoleAction->setEnabled(false);
	newHoleAction->setEnabled(false);
	setHoleOtherEnabled(true);

	if (game)
		game->setFocus();
}

void Kolf::inPlayStart()
{
	setEditingEnabled(false);
	setHoleOtherEnabled(false);
	setHoleMovementEnabled(false);
}

void Kolf::inPlayEnd()
{
	setEditingEnabled(true);
	setHoleOtherEnabled(true);
	setHoleMovementEnabled(true);
}

void Kolf::maxStrokesReached(const TQString &name)
{
	KMessageBox::sorry(this, i18n("%1's score has reached the maximum for this hole.").arg(name));
}

void Kolf::updateHoleMenu(int largest)
{
	TQStringList items;
	for (int i = 1; i <= largest; ++i)
		items.append(TQString::number(i));

	// setItems for some reason enables the action
	bool shouldbe = holeAction->isEnabled();
	holeAction->setItems(items);
	holeAction->setEnabled(shouldbe);
}

void Kolf::setHoleMovementEnabled(bool yes)
{
	if (competition)
		yes = false;

	holeAction->setEnabled(yes);

	nextAction->setEnabled(yes);
	prevAction->setEnabled(yes);
	firstAction->setEnabled(yes);
	lastAction->setEnabled(yes);
	randAction->setEnabled(yes);
}

void Kolf::setHoleOtherEnabled(bool yes)
{
	if (competition)
		yes = false;

	resetHoleAction->setEnabled(yes);
	undoShotAction->setEnabled(yes);
	//replayShotAction->setEnabled(yes);
}

void Kolf::setEditingEnabled(bool yes)
{
	editingAction->setEnabled(competition? false : yes);
}

void Kolf::checkEditing()
{
	editingAction->setChecked(true);
}

void Kolf::print()
{
	KPrinter pr;
	pr.addDialogPage(new PrintDialogPage());

    if (pr.setup(this, i18n("Print %1 - Hole %2").arg(game->courseName()).arg(game->currentHole())))
	{
		pr.newPage();
		if (game)
			game->print(pr);
	}
}

void Kolf::updateModified(bool mod)
{
	courseModified = mod;
	titleChanged(title);
}

void Kolf::titleChanged(const TQString &newTitle)
{
	title = newTitle;
	setCaption(title, courseModified);
}

void Kolf::useMouseChanged(bool yes)
{
	TDEConfig *config = kapp->config(); config->setGroup("Settings"); config->writeEntry("useMouse", yes); config->sync();
}

void Kolf::useAdvancedPuttingChanged(bool yes)
{
	TDEConfig *config = kapp->config(); config->setGroup("Settings"); config->writeEntry("useAdvancedPutting", yes); config->sync();
}

void Kolf::showInfoChanged(bool yes)
{
	TDEConfig *config = kapp->config(); config->setGroup("Settings"); config->writeEntry("showInfo", yes); config->sync();
}

void Kolf::showGuideLineChanged(bool yes)
{
	TDEConfig *config = kapp->config(); config->setGroup("Settings"); config->writeEntry("showGuideLine", yes); config->sync();
}

void Kolf::soundChanged(bool yes)
{
	TDEConfig *config = kapp->config(); config->setGroup("Settings"); config->writeEntry("sound", yes); config->sync();
}

void Kolf::initPlugins()
{
	//kdDebug(12007) << "initPlugins" << endl;
	if (game)
		game->pause();

	obj->setAutoDelete(true);
	obj->clear();
	plugins.setAutoDelete(false);
	plugins.clear();

	// add prefab objects
	obj->append(new SlopeObj());
	obj->append(new PuddleObj());
	obj->append(new WallObj());
	obj->append(new CupObj());
	obj->append(new SandObj());
	obj->append(new WindmillObj());
	obj->append(new BlackHoleObj());
	obj->append(new FloaterObj());
	obj->append(new BridgeObj());
	obj->append(new SignObj());
	obj->append(new BumperObj());

	ObjectList *other = PluginLoader::loadAll();
	Object *object = 0;
	for (object = other->first(); object; object = other->next())
	{
		obj->append(object);
		plugins.append(object);
	}

	if (game)
	{
		game->setObjects(obj);
		game->unPause();
	}

	//kdDebug(12007) << "end of initPlugins" << endl;
}

void Kolf::showPlugins()
{
	TQString text = TQString("<h2>%1</h2><ol>").arg(i18n("Currently Loaded Plugins"));
	Object *object = 0;
	for (object = plugins.first(); object; object = plugins.next())
	{
		text.append("<li>");
		text.append(object->name());
		text.append(" - ");
		text.append(i18n("by %1").arg(object->author()));
		text.append("</li>");
	}
	text.append("</ol>");
	KMessageBox::information(this, text, i18n("Plugins"));
}

void Kolf::enableAllMessages()
{
	KMessageBox::enableAllMessages();
}

void Kolf::setCurrentHole(int hole)
{
	if (!holeAction)
		return;
	// Golf is 1-based, TDEListAction is 0-based
	holeAction->setCurrentItem(hole - 1);
}

#include "kolf.moc"
