/* This file is part of the KDE libraries
    Copyright (C) 1997 Martin Jones (mjones@kde.org)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
//-----------------------------------------------------------------------------
// KDE color selection combo box

// layout management added Oct 1997 by Mario Weilguni
// <mweilguni@sime.com>


#ifndef COLORCOMBO_H
#define COLORCOMBO_H

#include <tqcombobox.h>
#include <kdialogbase.h>
#include <tqframe.h>
#include <tqpixmap.h>
#include <kcolordialog.h>
#include "tdeselect.h"


/**
 * Combobox for colours.
 */
class ColorCombo : public TQComboBox
{
  Q_OBJECT
  
public:
  ColorCombo( TQWidget *parent = 0L, const char *name = 0L );
  ~ColorCombo();

  void setColor( const TQColor &col );
  void setColorName(const TQString &color);
  TQString colorName();
  /**
   * Retrieve the currently selected color.
   **/
  TQColor color() const;

  bool hasColor() const;

public slots:
  void slotActivated( int index );
  void slotHighlighted( int index );

signals:
  void activated( const TQColor &col );
  void highlighted( const TQColor &col );

protected:
        /**
         * @reimplemented
         */
  virtual void resizeEvent( TQResizeEvent *re );

private:
  void createStandardPalette();
  void addColors();
  TQColor customColor;
  TQColor internalcolor;

  bool hascolor;

  TQColor *standardPalette;
  TQString *standardPaletteNames;


};

#endif  // COLORCOMBO_H
