/***************************************************************************
                             actionconfigdialog.cpp
                             ---------------------
    copyright            : (C) 2003 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef ACTIONCONFIGDIALOG_H
#define ACTIONCONFIGDIALOG_H

#include <tqmap.h>
#include "actionconfigdialogs.h"

class TQDomDocument;
class TQPopupMenu;

class TDEAction;
class TDEMainWindow;
class TDEPopupMenu;
class TDEShortcut;
class KXMLGUIClient;

struct ToolbarEntry {
  KXMLGUIClient *guiClient;
  TQDomDocument *dom;
  TQPopupMenu *menu;
  KURL url;
  TQString name;
  TQString id;
  bool user;
  bool visible;
  bool nameModified; ///< True if the name of the toolbar was modified by Quanta on loading:" (n)" was added
};

class ActionConfigDialog: public ActionConfigDialogS
{
  Q_OBJECT
  

public:

  ActionConfigDialog(const TQDict<ToolbarEntry> &toolbarList, TDEMainWindow* parent = 0, const char* name = 0, bool modal = true, WFlags fl = 0 , const TQString& defaultAction = TQString());
  ~ActionConfigDialog();
  void createScriptAction(const TQString& a_name, const TQString& a_script);

public slots:
  virtual void accept();
  virtual void reject();
  void slotToggled(bool);
  void slotTextChanged();
  void slotTextChanged(const TQString&);
  void slotNewAction();

private slots:
  void slotAddToolbar();
  void slotRemoveToolbar();
  void slotEditToolbar();
  void slotContextMenu(TDEListView *,TQListViewItem *,const TQPoint &);
  void slotSelectionChanged(TQListViewItem *);
  void slotShortcutCaptured(const TDEShortcut&);
  void slotDeleteAction();
  void slotApply();
  void slotAddContainerToolbar();
  void slotRemoveContainerToolbar();
  void slotToolbarRemoved(const TQString& toolbarName);
  
signals:
  void addToolbar();
  void removeToolbar(const TQString&);      
  void deleteUserAction(TDEAction *);
  void configureToolbars(const TQString&);

private:
  void saveCurrentAction();

  TDEPopupMenu *treeMenu;
  TDEAction *currentAction;
  TQListViewItem *allActionsItem;
  TQMap<TQString, TQString> globalShortcuts;
  TDEShortcut selectedShortcut;
  TDEMainWindow *m_mainWindow;
  TQDict<ToolbarEntry> m_toolbarList;
  TQListViewItem *m_toolbarItem;
};

#endif
