/***************************************************************************
                          pixmaplabel.h - Pixmap label widget 
                          -------------------
    copyright            : (C) 2002-2003 Marc Britton <consume@optusnet.com.au>
                           (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _HAVE_PIXMAPLABEL_H_
#define _HAVE_PIXMAPLABEL_H_

/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqstringlist.h>
#include <tqobject.h>
#include <tqstring.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <tqlabel.h>

class TQWidget;

class TQShowEvent;
class KOMMANDER_EXPORT PixmapLabel : public TQLabel, public KommanderWidget
{
  Q_OBJECT
  
  TQ_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  TQ_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  TQ_PROPERTY(bool KommanderWidget READ isKommanderWidget)
public:
  PixmapLabel(TQWidget *a_parent, const char *a_name);
  ~PixmapLabel();
  
  virtual bool isKommanderWidget() const;
  virtual void setAssociatedText(const TQStringList&);
  virtual TQStringList associatedText() const;
  virtual TQString currentState() const;
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);

  virtual TQString handleDCOP(int function, const TQStringList& args);    
  virtual bool isFunctionSupported(int function);
public slots:
  virtual void setWidgetText(const TQString&);
  virtual void populate();
signals:
  void widgetOpened();
  void widgetTextChanged(const TQString&);
  void contextMenuRequested(int xpos, int ypos);
protected:
  void showEvent(TQShowEvent *e);
  void contextMenuEvent( TQContextMenuEvent * e );
private:
};

#endif
