//
// C++ Interface: colordialog
//
// Description: 
//
//
// Author: Andras Mantia <amantia@kdewebdev.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef FONTDIALOG_H
#define FONTDIALOG_H

#include <tqlabel.h>
#include <kommanderwidget.h>

#include <tqfont.h>

/**
	@author Andras Mantia <amantia@kdewebdev.org>
*/
class KDE_EXPORT FontDialog : public TQLabel, public KommanderWidget
{
  Q_OBJECT
  
  TQ_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  TQ_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  TQ_PROPERTY(bool KommanderWidget READ isKommanderWidget)
public:
    FontDialog(TQWidget *parent = 0, const char *name = 0);

    ~FontDialog();

  virtual bool isKommanderWidget() const;
  virtual TQString currentState() const;
  virtual bool isFunctionSupported(int function);
  virtual TQString handleDCOP(int function, const TQStringList& args);
  virtual TQStringList associatedText() const;
  virtual void setAssociatedText(const TQStringList&);
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);

public slots:
  virtual void setWidgetText(const TQString &);
  virtual void populate();

public:
  TQFont m_font;
};

#endif
