/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/
#ifndef ASSISTPROC_H
#define ASSISTPROC_H

#include <tqprocess.h>
#include <tqtimer.h>
#include <tqsocket.h>
#include <tqstring.h>

class AssistProc : public TQProcess
{
    Q_OBJECT
  
public:
    AssistProc( TQObject *parent=0, const char * name = 0, const TQString &path = TQString() );
    ~AssistProc();
    bool run( const TQString &path = TQString() );

public slots:
    bool sendRequest( const TQString &data );

private slots:
    void processOutput();
    void processErrOutput();

private:
    TQString assistantPath;
};

#endif // ASSISTPROC_H
