/*
    From WebMaker - KDE HTML Editor
    Copyright (C) 1998, 1999 Alexei Dets <dets@services.ru>
    Rewritten for Quanta Plus: (C) 2002 Andras Mantia <amantia@freemail.hu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
*/

#ifndef _TQEXTFILEINFO_H_
#define _TQEXTFILEINFO_H_

#include <tdeio/global.h>
#include <tdeio/job.h>
#include <kurl.h>
#include <tdefileitem.h>

#include <tqobject.h>
#include <tqptrlist.h>
#include <tqregexp.h>

class QExtFileInfo:public TQObject
{
 Q_OBJECT
  
public:
  QExtFileInfo() {};
  ~QExtFileInfo() {};

  /** create to ralative short name */
  static KURL toRelative(const KURL& urlToConvert,const KURL& baseURL);
  /** convert relative filename to absolute */
  static KURL toAbsolute(const KURL& urlToConvert,const KURL& baseURL);
  /** recurse function for all files in dir */
  static KURL::List allFiles( const KURL& path, const TQString &mask);
  static KURL::List allFilesRelative( const KURL& path, const TQString &mask);
  /** create dir if don't exists */
  static bool createDir(const KURL & path );
  static KURL cdUp(const KURL &dir);
  static TQString shortName(const TQString &fname );
  static KURL path(const KURL &);
  static KURL home();
  static bool exists(const KURL& url);
  static bool copy( const KURL& src, const KURL& dest, int permissions=-1,
                    bool overwrite=false, bool resume=false, TQWidget* window = 0L );

  void enter_loop();

private:
  bool internalExists(const KURL& url);
  bool internalCopy(const KURL& src, const KURL& target, int permissions,
                    bool overwrite, bool resume, TQWidget* window);

  bool bJobOK;
  static TQString lastErrorMsg;
  TDEIO::UDSEntry m_entry;
  KURL::List dirListItems;
  TQPtrList<TQRegExp> lstFilters;

  /** No descriptions */
  KURL::List allFilesInternal(const KURL& startURL, const TQString& mask);

//  friend class I_like_this_class;

private slots:
   void slotResult( TDEIO::Job * job );
   void slotNewEntries(TDEIO::Job *job, const TDEIO::UDSEntryList& udsList);
public slots: // Public slots
  /** Timeout occured while waiting for some network function to return. */
  void slotTimeout();
};


#endif
