#ifndef __PROJECTMANAGER_H__
#define __PROJECTMANAGER_H__


#include <tqstring.h>
#include <tqobject.h>
#include <tqdict.h>


#include <kxmlguiclient.h>
#include <kservice.h>
#include <kurl.h>

class TDEAction;
class TDESelectAction;
class KService;
class ProjectInfo;
class ProjectSession;
class TDERecentFilesAction;
class KDevPlugin;


class ProjectInfo
{
public:
  KURL         m_projectURL;
  TQDomDocument m_document;
  TQString      m_profileName;
  TQString      m_projectName;
  TQString      m_projectPlugin, m_language, m_activeLanguage, m_vcsPlugin;
  TQStringList  m_ignoreParts, m_keywords;

  TQString sessionFile() const;
};

/**
Project manager.
Loads and unloads projects.
*/
class ProjectManager : public TQObject, public KXMLGUIClient
{
  Q_OBJECT
  

public:

  ~ProjectManager();

  static TQString projectDirectory( const TQString& path, bool absolute );

  static ProjectManager *getInstance();

  void loadSettings();
  void saveSettings();
  void loadDefaultProject();

  bool projectLoaded() const;

  KURL projectFile() const;
  TQString projectName() const;

  void createActions( TDEActionCollection* ac );

  ProjectSession* projectSession() const;

public slots:
  bool loadProject( const KURL& url);
  bool loadKDevelop2Project( const KURL& url);
  bool closeProject( bool exiting = false );

private slots:
  void slotOpenProject();
  void slotProjectOptions();

  void slotLoadProject();

  void loadLocalParts();

private:
  ProjectManager();

  void setupActions();
  void getGeneralInfo();

  bool loadProjectFile();
  bool saveProjectFile();

  bool loadProjectPart();
  void unloadProjectPart();

  bool loadLanguageSupport(const TQString& lang);
  void unloadLanguageSupport();

//   TQString profileByAttributes(const TQString &language, const TQStringList &keywords);

  ProjectInfo *m_info;

  TDEAction *m_closeProjectAction, *m_projectOptionsAction;
  TDERecentFilesAction *m_openRecentProjectAction;

  static ProjectManager *s_instance;

  ProjectSession* m_pProjectSession;

  KDevPlugin *m_vcsPlugin;
  TQString m_vcsName;

  TQString m_oldProfileName;
};


#endif
