#ifndef __VALGRIND_WIDGET_H__
#define __VALGRIND_WIDGET_H__

#include <tqwidget.h>
#include <tqstring.h>
#include <tqstringlist.h>

#include "valgrinditem.h"

class ValgrindPart;
class TDEListView;
class TQListViewItem;
class TQPopupMenu;

class ValgrindWidget : public TQWidget
{
  Q_OBJECT
  
    
public:
  ValgrindWidget( ValgrindPart *part );
  ~ValgrindWidget();
  
  void addMessage( const ValgrindItem& vi );
  void clear();

signals:
  void jumpToFile( const TQString& url, int line );
  
private slots:
  void executed( TQListViewItem* item );
  void slotContextMenu( TDEListView* l, TQListViewItem* i, const TQPoint& p );
  void expandAll();
  void collapseAll();
  void aboutToShowPopup();
    
private:
  TDEListView* lv;
  int msgNumber;
  ValgrindPart* _part;
  TQPopupMenu* popup;
};


#endif
