 
#ifndef _VALGRIND_DIALOG_H_
#define _VALGRIND_DIALOG_H_

#include <kdialogbase.h>

class KURLRequester;
class DialogWidget;

/**
 * 
 * Harald Fernengel
 **/
class ValgrindDialog : public KDialogBase
{
    Q_OBJECT
  
public:
  enum Type { Memcheck = 0, Calltree = 1 };
    
  ValgrindDialog( Type type, TQWidget* parent = 0 );
  ~ValgrindDialog();

  // the app to check
  TQString executableName() const;
  void setExecutable( const TQString& url );

  // command line parameters for the app
  TQString parameters() const;
  void setParameters( const TQString& params );

  // name and/or path to the valgrind executable
  TQString valExecutable() const;
  void setValExecutable( const TQString& ve );

  // command line parameters for valgrind
  TQString valParams() const;
  void setValParams( const TQString& params );
  
  // name and/or path to the calltree executable
  TQString ctExecutable() const;
  void setCtExecutable( const TQString& ce );
  
  // command line parameters for calltree
  TQString ctParams() const;
  void setCtParams( const TQString& params );

  // name and/or path to the tdecachegrind executable
  TQString kcExecutable() const;
  void setKcExecutable( const TQString& ke );
        
protected:
  bool isNewValgrindVersion() const;
  
private:
  DialogWidget *w;
  Type m_type;
  private slots:
      void valgrindTextChanged();

};

#endif
