#include <tqcheckbox.h>
#include <tqradiobutton.h>
#include <tqstring.h>
#include <tqregexp.h>
#include <tqlabel.h>

#include <ktrader.h>
#include <tdeparts/componentfactory.h>
#include <kregexpeditorinterface.h>
#include <kurlrequester.h>
#include <kurlcompletion.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <kdebug.h>

#include "replacedlgimpl.h"

namespace
{
/// @todo This is the same function as in ../grepview/grepviewwidget.cpp and
/// should probably be placed in a common place. For now it seemed like too
/// little code to bother with.
TQString escape(const TQString &str)
{
    TQString escaped("[]{}()\\^$?.+-*");
    TQString res;

    for (uint i=0; i < str.length(); ++i)
    {
        if (escaped.find(str[i]) != -1)
            res += "\\";
        res += str[i];
    }

    return res;
}
}


ReplaceDlgImpl::ReplaceDlgImpl(TQWidget* parent, const char* name, bool modal, WFlags fl)
        : ReplaceDlg(parent,name, modal,fl), _regexp_dialog( 0 )

{
    connect( find_button, TQT_SIGNAL( clicked() ), TQT_SLOT( saveComboHistories() ) );
    connect( regexp_button, TQT_SIGNAL( clicked() ), TQT_SLOT( showRegExpEditor() ) );
    connect( find_combo, TQT_SIGNAL( textChanged( const TQString & ) ),
        TQT_SLOT( validateFind( const TQString & ) ) );
    connect( regexp_combo, TQT_SIGNAL( textChanged ( const TQString & ) ),
             TQT_SLOT( validateExpression( const TQString & ) ) );
    connect( strings_regexp_radio, TQT_SIGNAL( toggled( bool ) ), TQT_SLOT( toggleExpression( bool ) ) );

    // disable the editor button if the regexp editor isn't installed
    if ( TDETrader::self()->query("KRegExpEditor/KRegExpEditor").isEmpty() )
    {
        strings_regexp_radio->disconnect( regexp_button );
    }

    path_urlreq->completionObject()->setMode(KURLCompletion::DirCompletion);
    path_urlreq->setMode( KFile::Directory | KFile::LocalOnly );

    expression_varning_label->hide();
}

ReplaceDlgImpl::~ReplaceDlgImpl()
{}

void ReplaceDlgImpl::show( TQString const & path )
{
    path_urlreq->lineEdit()->setText( path );

    find_combo->setCurrentText( "" );
    replacement_combo->setCurrentText( "" );
    regexp_combo->setCurrentText( "" );

    strings_all_radio->setChecked( true );
    find_combo->setFocus();
    
    find_button->setEnabled( false );

    TQDialog::show();
}


void ReplaceDlgImpl::showRegExpEditor()
{
    _regexp_dialog = KParts::ComponentFactory::createInstanceFromQuery<TQDialog>( "KRegExpEditor/KRegExpEditor" );

    if ( _regexp_dialog )
    {
        KRegExpEditorInterface *editor =
            static_cast<KRegExpEditorInterface *>( _regexp_dialog->tqt_cast( "KRegExpEditorInterface" ) );

        editor->setRegExp( regexp_combo->currentText() );

        if ( _regexp_dialog->exec() == TQDialog::Accepted )
        {
            regexp_combo->setCurrentText( editor->regExp() );
        }
    }
}

void ReplaceDlgImpl::validateFind( const TQString & )
{
    //kdDebug(0) << "ReplaceWidget::validateFind()" << endl;

    bool x = find_combo->currentText().isEmpty() && ! strings_regexp_radio->isOn();
    find_button->setEnabled( !x );
}

void ReplaceDlgImpl::validateExpression( const TQString & )
{
    //kdDebug(0) << "ReplaceWidget::validateExpression()" << endl;

    TQString pattern = regexp_combo->currentText();
    TQRegExp re( pattern );

    if ( pattern.isEmpty() || !re.isValid() )
    {
        expression_varning_label->show();
        find_button->setEnabled( false );
    }
    else
    {
        expression_varning_label->hide();
        find_button->setEnabled( true );
    }
}

void ReplaceDlgImpl::toggleExpression( bool on )
{
    if ( on )
    {
        validateExpression( TQString() );
    }
    else
    {
        expression_varning_label->hide();
        find_button->setEnabled( true );
    }
}

void ReplaceDlgImpl::saveComboHistories()
{
    if ( find_combo->isEnabled() && ! find_combo->currentText().isEmpty() )
    {
        find_combo->addToHistory( find_combo->currentText() );
    }

    if ( ! replacement_combo->currentText().isEmpty() )
    {
        replacement_combo->addToHistory( replacement_combo->currentText() );
    }

    if ( regexp_combo->isEnabled() && ! regexp_combo->currentText().isEmpty() )
    {
        regexp_combo->addToHistory( regexp_combo->currentText() );
    }
}

TQRegExp ReplaceDlgImpl::expressionPattern()
{
    TQString pattern = escape( find_combo->currentText() );

    TQRegExp re;
    re.setCaseSensitive( case_box->isChecked() );
    re.setMinimal( true );

    if ( strings_wholewords_radio->isChecked() )
    {
        pattern = "\\b" + pattern + "\\b";
    }
    else if ( strings_regexp_radio->isChecked() )
    {
        pattern = regexp_combo->currentText();
    }

    re.setPattern( pattern );

    return re;
}

TQString ReplaceDlgImpl::replacementString()
{
    return replacement_combo->currentText();
}

#include "replacedlgimpl.moc"

