/***************************************************************************
 *   Copyright (C) 1999-2001 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _GREPVIEWPART_H_
#define _GREPVIEWPART_H_

#include <tqguardedptr.h>
#include <kdevgenericfactory.h>
#include "kdevplugin.h"

class KDialogBase;
class TQPopupMenu;
class Context;
class GrepViewWidget;


class GrepViewPart : public KDevPlugin
{
    Q_OBJECT
  

public:
    GrepViewPart( TQObject *parent, const char *name, const TQStringList & );
    ~GrepViewPart();

private slots:
    void stopButtonClicked(KDevPlugin *which);
    void projectOpened();
    void projectClosed();
    void contextMenu(TQPopupMenu *popup, const Context *context);

    void slotGrep();
    void slotContextGrep();

private:
    TQGuardedPtr<GrepViewWidget> m_widget;
    TQString m_popupstr;
    friend class GrepViewWidget;
};

typedef KDevGenericFactory<GrepViewPart> GrepViewFactory;

#endif
