/***************************************************************************
 *   Copyright (C) 2002 Roberto Raggi                                      *
 *   roberto@kdevelop.org                                                  *
 *   Copyright (C) 2002 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *   Copyright (C) 2003 by Alexander Dymo                                  *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ABBREVPART_H_
#define _ABBREVPART_H_

#include <tqmap.h>
#include <tqptrlist.h>
#include "kdevplugin.h"

#include <tdetexteditor/codecompletioninterface.h>

class KDialogBase;

namespace KParts{
    class Part;
}

namespace KTextEditor{
    class Document;
    class EditInterface;
    class ViewCursorInterface;
}

struct CodeTemplate {
    TQString name;
    TQString description;
    TQString code;
    TQString suffixes;
};

class CodeTemplateList {
public:
    CodeTemplateList();
    ~CodeTemplateList();

    TQMap<TQString, CodeTemplate* > operator[](TQString suffix);
    void insert(TQString name, TQString description, TQString code, TQString suffixes);
    void remove(const TQString &suffixes, const TQString &name);
    void clear();
    TQStringList suffixes();

    TQPtrList<CodeTemplate> allTemplates() const;

private:
    TQMap<TQString, TQMap<TQString, CodeTemplate* > > templates;
    TQPtrList<CodeTemplate> allCodeTemplates;
    TQStringList m_suffixes;
};

class AbbrevPart : public KDevPlugin
{
    Q_OBJECT
  

public:
    AbbrevPart( TQObject *parent, const char *name, const TQStringList & );
    ~AbbrevPart();

    bool autoWordCompletionEnabled() const;
    void setAutoWordCompletionEnabled( bool enabled );

    void addTemplate(const TQString &templ, const TQString &descr,
                     const TQString &suffixes, const TQString &code);
    void removeTemplate(const TQString &suffixes, const TQString &name);
    void clearTemplates();
    CodeTemplateList templates() const;

private slots:
    void slotExpandText();
    void slotExpandAbbrev();
    void configWidget(KDialogBase *dlg);
    void slotActivePartChanged( KParts::Part* );
    void slotTextChanged();
    void slotCompletionAborted();
    void slotCompletionDone();
    void slotFilterInsertString( KTextEditor::CompletionEntry*, TQString* );
    void slotAboutToShowCompletionBox();

private:
    void updateActions();
    void load();
    void save();
    TQString currentWord() const;
    TQValueList<KTextEditor::CompletionEntry> findAllWords(const TQString &text, const TQString &prefix);
    void insertChars( const TQString &chars );
//    TQAsciiDict<CodeTemplate> m_templates;
    CodeTemplateList m_templates;
    bool m_inCompletion;
    int m_prevLine;
    int m_prevColumn;
    int m_sequenceLength;
    bool m_autoWordCompletionEnabled;
    TQString m_completionFile;

    KTextEditor::Document* docIface;
    KTextEditor::EditInterface* editIface;
    KTextEditor::ViewCursorInterface* viewCursorIface;
    KTextEditor::CodeCompletionInterface* completionIface;
};

#endif
