/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef PDUMMYWIDGET_H
#define PDUMMYWIDGET_H

#include "propertywidget.h"
#include "multiproperty.h"

class TQWidget;
class TQVariant;
class TQPainter;
class TQColorGroup;
class TQRect;

namespace PropertyLib{

/**
@short %Property editor with empty widget.

This is usefull for properties which can't be edited in a generic way
like TQValueList's or TQMap's stored in a variant.
*/
class PDummyWidget: public PropertyWidget
{
    Q_OBJECT
  
public:
    PDummyWidget(MultiProperty *property, TQWidget *parent = 0, const char *name = 0);

    /**@return the value currently entered in the editor widget.*/
    virtual TQVariant value() const;
    /**Sets the value shown in the editor widget. Set emitChange to false
    if you don't want to emit propertyChanged signal.*/
    virtual void setValue(const TQVariant& value, bool emitChange);
    /**Function to draw a property viewer when the editor isn't shown.*/
    virtual void drawViewer(TQPainter *p, const TQColorGroup &cg, const TQRect &r, const TQVariant &value);
    
private:
    TQVariant m_value;
};

}

#endif
