/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef PDATEEDIT_H
#define PDATEEDIT_H

#include "propertywidget.h"

class TQDateEdit;

namespace PropertyLib{

/**
@short %Property editor for TQDate values.
*/
class PDateEdit : public PropertyWidget
{
Q_OBJECT
  
public:
    PDateEdit(MultiProperty* property, TQWidget* parent=0, const char* name=0);

    virtual TQVariant value() const;
    virtual void drawViewer(TQPainter* p, const TQColorGroup& cg, const TQRect& r, const TQVariant& value);
    virtual void setValue(const TQVariant& value, bool emitChange);

private slots:
    void updateProperty(const TQDate &val);    

private:
    TQDateEdit *m_edit;
};

}

#endif
