/***************************************************************************
 *   Copyright (C) 2002-2004 by Alexander Dymo                             *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "pcolorcombo.h"

#include <tqlayout.h>
#include <tqpainter.h>

#include <kcolorcombo.h>

namespace PropertyLib{

PColorCombo::PColorCombo(MultiProperty *property, TQWidget *parent, const char *name)
    :PropertyWidget(property, parent, name)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
    m_edit = new KColorCombo(this);
    m_edit->setSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
    l->addWidget(m_edit);

    connect(m_edit, TQT_SIGNAL(activated(int)), this, TQT_SLOT(updateProperty(int)));
}

TQVariant PColorCombo::value() const
{
    return TQVariant(m_edit->color());
}

void PColorCombo::setValue(const TQVariant &value, bool emitChange)
{
    disconnect(m_edit, TQT_SIGNAL(activated(int)), this, TQT_SLOT(updateProperty(int)));
    m_edit->setColor(value.toColor());
    connect(m_edit, TQT_SIGNAL(activated(int)), this, TQT_SLOT(updateProperty(int)));
    if (emitChange)
        emit propertyChanged(m_property, value);
}

void PColorCombo::updateProperty(int /*val*/)
{
    emit propertyChanged(m_property, value());
}

void PColorCombo::drawViewer(TQPainter *p, const TQColorGroup &cg, const TQRect &r, const TQVariant &value)
{
    p->setPen(TQt::NoPen);
    p->setBrush(cg.background());
    p->drawRect(r);
    
    p->setBrush(value.toColor());
    p->setPen(TQt::SolidLine);
    TQRect r2(r);
    r2.setTopLeft(r.topLeft() + TQPoint(5,5));
    r2.setBottomRight(r.bottomRight() - TQPoint(5,5));
    p->drawRect(r2);
}

}

#ifndef PURE_QT
#include "pcolorcombo.moc"
#endif

