/***************************************************************************
 *   Copyright (C) 2003 Alexander Dymo                                     *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef OPTIONTABS_H
#define OPTIONTABS_H

#include <tqwidget.h>

class TQSpinBox;
class TQRadioButton;
class FlagRadioButton;
class FlagCheckBoxController;
class FlagRadioButtonController;
class FlagPathEditController;
class FlagEditController;

class FeedbackTab : public TQWidget
{
public:
    FeedbackTab( TQWidget *parent=0, const char *name=0 );
    ~FeedbackTab();

    void readFlags(TQStringList *str);
    void writeFlags(TQStringList *str);

private:
    FlagCheckBoxController *controller;
};

class FilesAndDirectoriesTab: public TQWidget
{
public:
    FilesAndDirectoriesTab( TQWidget *parent = 0, const char *name = 0);
    ~FilesAndDirectoriesTab();

    void readFlags(TQStringList *str);
    void writeFlags(TQStringList *str);

private:
    FlagCheckBoxController *controller;
    FlagPathEditController *pathController;
};

class FilesAndDirectoriesTab2: public TQWidget
{
public:
    FilesAndDirectoriesTab2( TQWidget *parent = 0, const char *name = 0);
    ~FilesAndDirectoriesTab2();

    void readFlags(TQStringList *str);
    void writeFlags(TQStringList *str);

private:
    FlagCheckBoxController *controller;
    FlagPathEditController *pathController;
};

class LanguageTab : public TQWidget
{
public:
    LanguageTab( TQWidget *parent=0, const char *name=0 );
    ~LanguageTab();

    void readFlags(TQStringList *str);
    void writeFlags(TQStringList *str);

private:
    FlagCheckBoxController *controller;
};

class AssemblerTab : public TQWidget
{
public:
    AssemblerTab( TQWidget *parent=0, const char *name=0 );
    ~AssemblerTab();

    void readFlags(TQStringList *str);
    void writeFlags(TQStringList *str);

private:
    FlagCheckBoxController *controller;
    FlagRadioButtonController *asmController;
};

class DebugOptimTab : public TQWidget
{
    Q_OBJECT
  
public:
    DebugOptimTab( TQWidget *parent=0, const char *name=0 );
    ~DebugOptimTab();

    void readFlags(TQStringList *str);
    void writeFlags(TQStringList *str);

private:
    FlagCheckBoxController *controller;
    FlagRadioButtonController *optimController;

    TQRadioButton *m_default;
    TQRadioButton *m_default2;
    TQRadioButton *m_default3;
    FlagRadioButton *optim1;
    FlagRadioButton *optim2;

private slots:
    void setReleaseOptions();
    void setDebugOptions();
};

class CodegenTab : public TQWidget
{
public:
    CodegenTab( TQWidget *parent=0, const char *name=0 );
    ~CodegenTab();

    void readFlags(TQStringList *str);
    void writeFlags(TQStringList *str);

private:
    FlagCheckBoxController *controller;
    FlagEditController *listController;
};

class LinkerTab : public TQWidget
{
public:
    LinkerTab( TQWidget *parent=0, const char *name=0 );
    ~LinkerTab();

    void readFlags(TQStringList *str);
    void writeFlags(TQStringList *str);

private:
    FlagCheckBoxController *controller;
    FlagEditController *listController;
};

class MiscTab : public TQWidget
{
public:
    MiscTab( TQWidget *parent=0, const char *name=0 );
    ~MiscTab();

    void readFlags(TQStringList *str);
    void writeFlags(TQStringList *str);

private:
    FlagCheckBoxController *controller;
    FlagRadioButtonController *radioController;
    FlagPathEditController *pathController;
    FlagEditController *editController;
};

#endif
