/***************************************************************************
 *   Copyright (C) 2001 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _PGIOPTIONSPLUGIN_H_
#define _PGIOPTIONSPLUGIN_H_

#include <kdialogbase.h>

#include "kdevcompileroptions.h"

class GeneralTab;
class OptimizationTab;
class HpfTab;


class PgiOptionsPlugin : public KDevCompilerOptions
{
    Q_OBJECT
  

public:
    enum Type { PGHPF, PGF77 };
    
    PgiOptionsPlugin( Type type, TQObject *parent=0, const char *name=0 );
    ~PgiOptionsPlugin();

    virtual TQString exec(TQWidget *parent, const TQString &flags);

private:
    Type pgitype;
};


class PgiOptionsDialog : public KDialogBase
{
public:
    PgiOptionsDialog(PgiOptionsPlugin::Type type, TQWidget *parent=0, const char *name=0 );
    ~PgiOptionsDialog();

    void setFlags(const TQString &flags);
    TQString flags() const;

private:
    OptimizationTab *optimization;
    HpfTab *hpf;
};

#endif
