/***************************************************************************
 *   Copyright (C) 2003 by Roberto Raggi                                   *
 *   roberto@kdevelop.org                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kdevqt4importer.h"
#include "kdevqt4importer.moc"
#include "settingsdialog.h"

#include <kgenericfactory.h>
#include <tdetempfile.h>
#include <kprocess.h>
#include <kdebug.h>

#include <tqtextstream.h>
#include <tqlabel.h>
#include <tqdir.h>

K_EXPORT_COMPONENT_FACTORY( libkdevqt4importer, KGenericFactory<KDevQt4Importer>( "kdevqt4importer" ) )

KDevQt4Importer::KDevQt4Importer( TQObject * parent, const char * name, const TQStringList& )
    : KDevPCSImporter( parent, name )
{
    m_qtfile = 0;
}

KDevQt4Importer::~KDevQt4Importer()
{
    if (m_qtfile)
        delete m_qtfile;

    m_qtfile = 0;
}

TQStringList KDevQt4Importer::fileList()
{
    if( !m_settings )
        return TQStringList();

    if (m_qtfile)
        delete m_qtfile;

    KTempFile ifile;
    TQTextStream &is = *ifile.textStream();

		is << "#include <TQtCore/tqobjectdefs.h>\n"
		   << "#undef slots\n#undef signals\n#undef slots\n#undef signals"
		   << "#define slots slots\n"
			 << "#define signals signals\n"
			 << "#include <TQtCore/TQtCore>\n"
       << "#include <TQtGui/TQtGui>\n"
       << "#include <TQtNetwork/TQtNetwork>\n"
       << "#include <TQtXml/TQtXml>\n"
       << "#include <TQt3Support/TQt3Support>\n"
       << "#include <TQtSql/TQtSql>\n"
       << "#include <TQtTest/TQtTest>\n"
			 << "#include <TQtOpenGL/TQtOpenGL>\n";
			


    TDEProcess proc;
    proc << "cpp" << "-nostdinc" << "-xc++";

    m_qtfile = new KTempFile();

    // include paths
    TQStringList paths = includePaths();
    for (TQStringList::Iterator it = paths.begin(); it != paths.end(); ++it)
        proc << "-I" << *it;

    ifile.close();

    TQString o;
    o += "-o";
    o += m_qtfile->name();

    proc << ifile.name() << o;
    proc.start(TDEProcess::Block);

    return m_qtfile->name();
}

TQStringList KDevQt4Importer::includePaths()
{
    if( !m_settings || !m_qtfile)
        return TQStringList();

    TQStringList includePaths;
    includePaths.push_back( m_settings->qtDir() );
    includePaths.push_back( m_settings->qtDir() + "/TQt" );

    /// @todo add mkspec
    return includePaths;
}

TQWidget * KDevQt4Importer::createSettingsPage( TQWidget * parent, const char * name )
{
    m_settings = new SettingsDialog( parent, name );
    return m_settings;
}

