/*
 * KDevelop config for split header/source
 *
 * Copyright (c) 2005 Adam Treat <treat@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#ifndef CPPSPLITHEADERSOURCECONFIG_H
#define CPPSPLITHEADERSOURCECONFIG_H

#include <tqobject.h>

class CppSupportPart;
class TQDomDocument;

class CppSplitHeaderSourceConfig : public TQObject
{
    Q_OBJECT
  
public:
    CppSplitHeaderSourceConfig( CppSupportPart* part, TQDomDocument* dom );
    virtual ~CppSplitHeaderSourceConfig();

    bool splitEnabled() const
    {
        return m_splitEnable;
    }
    void setSplitEnable( bool b );

    bool autoSync() const
    {
        return m_splitSync;
    }
    void setAutoSync( bool b );

    TQString orientation() const
    {
        return m_splitOrientation;
    }
    void setOrientation( const TQString &o );

public slots:
    void store();

private:
    void init();

signals:
    void stored();

private:
    CppSupportPart* m_part;
    TQDomDocument* m_dom;
    bool m_splitEnable;
    bool m_splitSync;
    TQString m_splitOrientation;

    static TQString defaultPath;
};

#endif 
