/**********************************************************************
** Copyright (C) 2000-2002 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include "actioneditorimpl.h"
#include "formwindow.h"
#include "metadatabase.h"
#include "actionlistview.h"
#include "connectiondialog.h"
#include "mainwindow.h"
#include "hierarchyview.h"
#include "formfile.h"

#include <tqaction.h>
#include <tqlineedit.h>
#include <tqlabel.h>
#include <tqtoolbutton.h>
#include <tqlistview.h>
#include <tqcheckbox.h>
#include <tqpushbutton.h>
#include <tqpopupmenu.h>
#include <tqobjectlist.h>

#include <tdelocale.h>

ActionEditor::ActionEditor( TQWidget* parent,  const char* name, WFlags fl )
    : ActionEditorBase( parent, name, fl ), currentAction( 0 ), formWindow( 0 ),
    explicitlyClosed(false)
{
    listActions->addColumn( i18n( "Actions" ) );
    setEnabled( FALSE );
    buttonConnect->setEnabled( FALSE );

    TQPopupMenu *popup = new TQPopupMenu( this );
    popup->insertItem( i18n( "New &Action" ), this, TQT_SLOT( newAction() ) );
    popup->insertItem( i18n( "New Action &Group" ), this, TQT_SLOT( newActionGroup() ) );
    popup->insertItem( i18n( "New &Dropdown Action Group" ), this, TQT_SLOT( newDropDownActionGroup() ) );
    buttonNewAction->setPopup( popup );
    buttonNewAction->setPopupDelay( 0 );

    connect( listActions, TQT_SIGNAL( insertAction() ), this, TQT_SLOT( newAction() ) );
    connect( listActions, TQT_SIGNAL( insertActionGroup() ), this, TQT_SLOT( newActionGroup() ) );
    connect( listActions, TQT_SIGNAL( insertDropDownActionGroup() ), this, TQT_SLOT( newDropDownActionGroup() ) );
    connect( listActions, TQT_SIGNAL( deleteAction() ), this, TQT_SLOT( deleteAction() ) );
    connect( listActions, TQT_SIGNAL( connectAction() ), this, TQT_SLOT( connectionsClicked() ) );
}

void ActionEditor::closeEvent( TQCloseEvent *e )
{
    emit hidden();
    e->accept();
}

void ActionEditor::currentActionChanged( TQListViewItem *i )
{
    buttonConnect->setEnabled( i != 0 );
    if ( !i )
	return;
    currentAction = ( (ActionItem*)i )->action();
    if ( !currentAction )
	currentAction = ( (ActionItem*)i )->actionGroup();
    if ( formWindow && currentAction )
	formWindow->setActiveObject( currentAction );
    MainWindow::self->objectHierarchy()->hierarchyList()->setCurrent( currentAction );
}

void ActionEditor::setCurrentAction( TQAction *a )
{
    TQListViewItemIterator it( listActions );
    while ( it.current() ) {
	if ( ( (ActionItem*)it.current() )->action() == a || ( (ActionItem*)it.current() )->actionGroup() == a ) {
	    listActions->setCurrentItem( it.current() );
	    listActions->ensureItemVisible( it.current() );
	    break;
	}
	++it;
    }
}

TQAction *ActionEditor::newActionEx()
{
    ActionItem *i = new ActionItem( listActions, (bool)FALSE );
    TQAction *a = i->action();
    TQObject::connect( a, TQT_SIGNAL( destroyed( TQObject * ) ),
		      this, TQT_SLOT( removeConnections( TQObject* ) ) );
    MetaDataBase::addEntry( i->action() );
    TQString n = "Action";
    formWindow->unify( i->action(), n, TRUE );
    i->setText( 0, n );
    i->action()->setName( n );
    i->action()->setText( i->action()->name() );
    MetaDataBase::setPropertyChanged( i->action(), "text", TRUE );
    MetaDataBase::setPropertyChanged( i->action(), "name", TRUE );
    formWindow->actionList().append( i->action() );
    if ( formWindow->formFile() )
	formWindow->formFile()->setModified( TRUE );
    return i->action();
}

void ActionEditor::deleteAction()
{
    if ( !currentAction )
	return;

    TQListViewItemIterator it( listActions );
    ActionItem *ai = 0;
    while ( it.current() ) {
	ai = (ActionItem*)it.current();
	if ( ai->action() == currentAction || ai->actionGroup() == currentAction ) {
	    emit removing( currentAction );
	    formWindow->actionList().removeRef( currentAction );
	    delete currentAction;
	    currentAction = 0;
	    delete it.current();
	    break;
	}
	++it;
    }
    if ( formWindow ) {
	formWindow->setActiveObject( TQT_TQOBJECT(formWindow->mainContainer()) );
	if ( formWindow->formFile() )
	    formWindow->formFile()->setModified( TRUE );
    }
}

void ActionEditor::newAction()
{
    ActionItem *actionParent = (ActionItem*)listActions->selectedItem();
    if ( actionParent ) {
	if ( !::tqqt_cast<TQActionGroup*>(actionParent->actionGroup()) )
	    actionParent = (ActionItem*)actionParent->parent();
    }

    ActionItem *i = 0;
    if ( actionParent )
	i = new ActionItem( actionParent );
    else
	i = new ActionItem( listActions, (bool)FALSE );
    TQAction *a = i->action();
    TQObject::connect( a, TQT_SIGNAL( destroyed( TQObject * ) ),
		      this, TQT_SLOT( removeConnections( TQObject* ) ) );
    MetaDataBase::addEntry( i->action() );
    TQString n = "Action";
    formWindow->unify( i->action(), n, TRUE );
    i->setText( 0, n );
    i->action()->setName( n );
    i->action()->setText( i->action()->name() );
    if ( actionParent && actionParent->actionGroup() &&
	 actionParent->actionGroup()->usesDropDown() ) {
	i->action()->setToggleAction( TRUE );
	MetaDataBase::setPropertyChanged( i->action(), "toggleAction", TRUE );
    }
    MetaDataBase::setPropertyChanged( i->action(), "text", TRUE );
    MetaDataBase::setPropertyChanged( i->action(), "name", TRUE );
    listActions->setCurrentItem( i );
    if ( !actionParent )
	formWindow->actionList().append( i->action() );
    if ( formWindow->formFile() )
	formWindow->formFile()->setModified( TRUE );
}

void ActionEditor::newActionGroup()
{
    ActionItem *actionParent = (ActionItem*)listActions->selectedItem();
    if ( actionParent ) {
	if ( !::tqqt_cast<TQActionGroup*>(actionParent->actionGroup()) )
	    actionParent = (ActionItem*)actionParent->parent();
    }

    ActionItem *i = 0;
    if ( actionParent )
	i = new ActionItem( actionParent, TRUE );
    else
	i = new ActionItem( listActions, TRUE );
    TQAction *ag = i->actionGroup();
    TQObject::connect( ag, TQT_SIGNAL( destroyed( TQObject * ) ),
		      this, TQT_SLOT( removeConnections( TQObject* ) ) );
    MetaDataBase::addEntry( i->actionGroup() );
    MetaDataBase::setPropertyChanged( i->actionGroup(), "usesDropDown", TRUE );
    TQString n = "ActionGroup";
    formWindow->unify( i->action(), n, TRUE );
    i->setText( 0, n );
    i->actionGroup()->setName( n );
    i->actionGroup()->setText( i->actionGroup()->name() );
    MetaDataBase::setPropertyChanged( i->actionGroup(), "text", TRUE );
    MetaDataBase::setPropertyChanged( i->actionGroup(), "name", TRUE );
    listActions->setCurrentItem( i );
    i->setOpen( TRUE );
    if ( !actionParent )
	formWindow->actionList().append( i->actionGroup() );
    if ( formWindow->formFile() )
	formWindow->formFile()->setModified( TRUE );
}

void ActionEditor::newDropDownActionGroup()
{
    newActionGroup();
    ( (ActionItem*)listActions->currentItem() )->actionGroup()->setUsesDropDown( TRUE );
}

void ActionEditor::setFormWindow( FormWindow *fw )
{
    listActions->clear();
    formWindow = fw;
    if ( !formWindow ||
	 !::tqqt_cast<TQMainWindow*>(formWindow->mainContainer()) ) {
	setEnabled( FALSE );
    } else {
	setEnabled( TRUE );
	for ( TQAction *a = formWindow->actionList().first(); a; a = formWindow->actionList().next() ) {
	    ActionItem *i = 0;
	    if ( ::tqqt_cast<TQAction*>(a->parent()) )
		continue;
	    i = new ActionItem( listActions, a );
	    i->setText( 0, a->name() );
	    i->setPixmap( 0, a->iconSet().pixmap() );
	    // make sure we don't duplicate the connection
 	    TQObject::disconnect( a, TQT_SIGNAL( destroyed( TQObject * ) ),
 				 this, TQT_SLOT( removeConnections( TQObject * ) ) );
	    TQObject::connect( a, TQT_SIGNAL( destroyed( TQObject * ) ),
			      this, TQT_SLOT( removeConnections( TQObject* ) ) );
	    if ( ::tqqt_cast<TQActionGroup*>(a) ) {
		insertChildActions( i );
	    }
	}
	if ( listActions->firstChild() ) {
	    listActions->setCurrentItem( listActions->firstChild() );
	    listActions->setSelected( listActions->firstChild(), TRUE );
	}
    }
}

void ActionEditor::insertChildActions( ActionItem *i )
{
    TQObjectList clo = i->actionGroup()->childrenListObject();
    if ( !i->actionGroup() || clo.isEmpty() )
	return;
    TQObjectListIt it( clo );
    while ( it.current() ) {
	TQObject *o = it.current();
	++it;
	if ( !::tqqt_cast<TQAction*>(o) )
	    continue;
	TQAction *a = (TQAction*)o;
	ActionItem *i2 = new ActionItem( (TQListViewItem*)i, a );
	i->setOpen( TRUE );
	i2->setText( 0, a->name() );
	i2->setPixmap( 0, a->iconSet().pixmap() );
	// make sure we don't duplicate the connection
 	TQObject::disconnect( o, TQT_SIGNAL( destroyed( TQObject * ) ),
 			     this, TQT_SLOT( removeConnections( TQObject * ) ) );
 	TQObject::connect( o, TQT_SIGNAL( destroyed( TQObject * ) ),
 			  this, TQT_SLOT( removeConnections( TQObject * ) ) );
	if ( ::tqqt_cast<TQActionGroup*>(a) )
	    insertChildActions( i2 );
    }
}

void ActionEditor::updateActionName( TQAction *a )
{
    TQListViewItemIterator it( listActions );
    while ( it.current() ) {
	if ( ( (ActionItem*)it.current() )->action() == a )
	    ( (ActionItem*)it.current() )->setText( 0, a->name() );
	else if ( ( (ActionItem*)it.current() )->actionGroup() == a )
	    ( (ActionItem*)it.current() )->setText( 0, a->name() );
	++it;
    }
}

void ActionEditor::updateActionIcon( TQAction *a )
{
    TQListViewItemIterator it( listActions );
    while ( it.current() ) {
	if ( ( (ActionItem*)it.current() )->action() == a )
	    ( (ActionItem*)it.current() )->setPixmap( 0, a->iconSet().pixmap() );
	else if ( ( (ActionItem*)it.current() )->actionGroup() == a )
	    ( (ActionItem*)it.current() )->setPixmap( 0, a->iconSet().pixmap() );
	++it;
    }
}

void ActionEditor::connectionsClicked()
{
    ConnectionDialog dlg( formWindow->mainWindow() );
    dlg.setDefault( TQT_TQOBJECT(currentAction), TQT_TQOBJECT(formWindow) );
    dlg.addConnection();
    dlg.exec();
}

void ActionEditor::removeConnections( TQObject *o )
{
    TQValueList<MetaDataBase::Connection> conns =
	MetaDataBase::connections( TQT_TQOBJECT(formWindow), o );
    for ( TQValueList<MetaDataBase::Connection>::Iterator it2 = conns.begin();
	  it2 != conns.end(); ++it2 )
	MetaDataBase::removeConnection( TQT_TQOBJECT(formWindow), (*it2).sender, (*it2).signal,
					(*it2).receiver, (*it2).slot );
}
