/***************************************************************************
 *   Copyright (C) 2003 Alexander Dymo                                     *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef PASCALPROJECTOPTIONSDLG_H
#define PASCALPROJECTOPTIONSDLG_H

#include <ktrader.h>

#include "pascalproject_optionsdlgbase.h"

class PascalProjectPart;
class KDevCompilerOptions;

class PascalProjectOptionsDlg : public PascalProjectOptionsDlgBase
{
  Q_OBJECT
  

public:
    PascalProjectOptionsDlg(PascalProjectPart *part, TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~PascalProjectOptionsDlg();

public slots:
    virtual void accept();

protected slots:
    virtual void compiler_box_activated(const TQString &s);
    void configComboTextChanged(const TQString &config);
    void configChanged(const TQString &config);
    void configAdded();
    void configRemoved();
    void optionsButtonClicked();
    void setDirty();
    void setDefaultOptions();

private:
    TQStringList allConfigs;
    TQString currentConfig;
    bool dirty;

    TDETrader::OfferList offers;
    TQStringList service_names;
    TQStringList service_execs;

    PascalProjectPart *m_part;

    void saveConfig(TQString config);
    void readConfig(TQString config);
    TQStringList allBuildConfigs();
};

#endif

