/***************************************************************************
 *   Copyright (C) 2001-2002 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "addfiledlg.h"

#include <tqcheckbox.h>
#include <tqfile.h>
#include <tqfileinfo.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqtextstream.h>

#include <kbuttonbox.h>
#include <kdebug.h>
#include <kdialog.h>
#include <klineedit.h>
#include <tdemessagebox.h>
#include <ksqueezedtextlabel.h>
#include <kurl.h>

#include "autolistviewitems.h"

#include "filetemplate.h"
#include "misc.h"
#include "urlutil.h"
#include "autoprojectpart.h"
#include "autoprojectwidget.h"

#include "kdevpartcontroller.h"

AddFileDialog::AddFileDialog(AutoProjectPart *part, AutoProjectWidget *widget,
							SubprojectItem *spitem, TargetItem *item,
							TQWidget *parent, const char *name)
	: AddFileDlgBase(parent, name, true)
{
	connect ( createButton, TQT_SIGNAL ( clicked() ), this, TQT_SLOT ( accept() ) );
	connect ( cancelButton, TQT_SIGNAL ( clicked() ), this, TQT_SLOT ( reject() ) );

	directoryLabel->setText ( spitem->path );
	if ( item->name.isEmpty() )
		targetLabel->setText ( i18n ( "%1 in %2" ).arg ( item->primary ).arg ( item->prefix ) );
	else
		targetLabel->setText ( item->name );

	setIcon ( SmallIcon ( "filenew.png" ) );

	m_part = part;
	m_widget = widget;
	subProject = spitem;
	target = item;
}


AddFileDialog::~AddFileDialog()
{}


void AddFileDialog::accept()
{
	TQString name = fileEdit->text();
	if (name.find('/') != -1) {
		KMessageBox::sorry(this, i18n("Please enter the file name without '/' and so on."));
		return;
	}

	TQListViewItem *child = target->firstChild();
	while (child) {
		FileItem *item = static_cast<FileItem*>(child);
		if (name == item->name) {
			KMessageBox::sorry(this, i18n("This file is already in the target."));
			return;
		}
		child = child->nextSibling();
	}

	if (templateCheckBox->isChecked()) {
		TQString srcdir = m_part->projectDirectory();
		TQString destdir = subProject->path;
		TQString destpath = destdir + "/" + name;
		if (TQFileInfo(destpath).exists()) {
			KMessageBox::sorry(this, i18n("<b>A file with this name already exists.</b><br><br>Please use the \"Add existing file\" dialog."));
			return;
		}
		if( !FileTemplate::copy(m_part, TQFileInfo(name).extension(), destpath) )
		    kdDebug(9020) << "cannot create file " << destpath << endl;
	} else {
		// create an empty file
		TQString srcdir = m_part->projectDirectory();
		TQString destdir = subProject->path;
		TQString destpath = destdir + "/" + name;

		if (TQFileInfo(destpath).exists()) {
			KMessageBox::sorry(this, i18n("<b>A file with this name already exists.</b><br><br>Please use the \"Add existing file\" dialog."));
			return;
		}

		TQFile f( destpath );
		if( f.open(IO_WriteOnly) )
		    f.close();
	}

	FileItem *fitem = m_widget->createFileItem(name, subProject);
	target->sources.append(fitem);
	target->insertItem(fitem);

	TQString canontargetname = AutoProjectTool::canonicalize(target->name);
	TQString varname;
        if( target->primary == "PROGRAMS" || target->primary == "LIBRARIES" || target->primary == "LTLIBRARIES" )
            varname = canontargetname + "_SOURCES";
        else
            varname = target->prefix + "_" + target->primary;
	subProject->variables[varname] += (" " + name);

	TQMap<TQString,TQString> replaceMap;
	replaceMap.insert(varname, subProject->variables[varname]);

	AutoProjectTool::addToMakefileam(subProject->path + "/Makefile.am", replaceMap);

	m_widget->emitAddedFile( subProject->path.mid ( m_part->project()->projectDirectory().length() + 1 ) + "/" + name );
	m_part->partController()->editDocument ( KURL ( subProject->path + "/" + name ) );

	TQDialog::accept();
}

#include "addfiledlg.moc"
