/* Copyright (C) 2003 Oliver Kellogg
 * okellogg@users.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */
#ifndef __KDEVPART_ADAPROJECT_H__
#define __KDEVPART_ADAPROJECT_H__

#include <tqguardedptr.h>

#include "kdevbuildtool.h"

class AdaProjectWidget;
class KDialogBase;
class KDevCompilerOptions;

class AdaProjectPart : public KDevBuildTool
{
    Q_OBJECT
  
public:
    AdaProjectPart(TQObject *parent, const char *name, const TQStringList &);
    ~AdaProjectPart();

    virtual void openProject(const TQString &dirName, const TQString &projectName);
    virtual void closeProject();

    /**Returns the name of the main source file without extension.
       We assume that all Ada compilers call the binary that way.  */
    virtual TQString mainProgram() const;
    /**Main source file (like src/main.adb)*/
    virtual TQString mainSource() const;
    virtual void setMainSource(TQString fullPath);

    virtual TQString projectDirectory() const;
    virtual TQString projectName() const;
    virtual TQString activeDirectory() const;
    /**The location of the main source file*/
    virtual TQString buildDirectory() const;
    virtual TQString runDirectory() const;
    virtual TQString debugArguments() const;
    virtual TQString runArguments() const;
    virtual DomUtil::PairList runEnvironmentVars() const;

    /**Returns everything in the project directory*/
    virtual TQStringList allFiles() const;
    /**This does absolutelly nothing*/
    virtual void addFile(const TQString &fileName);
    /**This does absolutelly nothing*/
    virtual void addFiles(const TQStringList &fileList);
    /**This does absolutelly nothing*/
    virtual void removeFile(const TQString &fileName);
    /**This does absolutelly nothing*/
    virtual void removeFiles(const TQStringList &fileList);

    virtual void changedFiles( const TQStringList & fileList );
    virtual void changedFile( const TQString & fileName );

    KDevCompilerOptions *createCompilerOptions(const TQString &name);

    virtual TQString defaultOptions(const TQString compiler);
    TQStringList distFiles() const;

public slots:
    /**loads config from project file*/
    void loadProjectConfig();

private slots:
    void slotBuild();
    void slotExecute();
    void projectConfigWidget(KDialogBase *dlg);
    void configWidget(KDialogBase *dlg);

private:
    TQGuardedPtr<AdaProjectWidget> m_widget;

    void listOfFiles(TQStringList &result, TQString path) const;

    TQString m_buildDir;
    TQString m_projectDir;
    TQString m_projectName;

    TQString m_mainProg;
    TQString m_mainSource;
    TQString m_compilerExec;
    TQString m_compilerOpts;

    TQStringList m_sourceFiles;
};

#endif
