/***************************************************************************
                                komparenavtreepart.h  -  description
                                -------------------
        begin                   : Mon Feb 26 2002
        copyright               : (C) 2001-2004 Otto Bruggeman
                                  (C) 2001-2003 John Firebaugh
        email                   : otto.bruggeman@home.nl
                                  jfirebaugh@kde.org
****************************************************************************/

/***************************************************************************
**
**   This program is free software; you can redistribute it and/or modify
**   it under the terms of the GNU General Public License as published by
**   the Free Software Foundation; either version 2 of the License, or
**   (at your option) any later version.
**
***************************************************************************/

#ifndef KOMPARENAVTREEPART_H
#define KOMPARENAVTREEPART_H

#include <tqptrdict.h>
#include <tqptrlist.h>
#include <tqsplitter.h>
#include <tqlistview.h>

#include <tdeparts/factory.h>
#include <tdeparts/part.h>

#include "kompare.h"
#include "diffmodellist.h"

class KompareModelList;
class KomparePart;
class TDEListView;

namespace Diff2 {
class DiffModel;
class Difference;
}

class KDirLVI;
class KFileLVI;
class KChangeLVI;

class KompareNavTreePart : public KParts::ReadOnlyPart
{
	Q_OBJECT
  

public:
	KompareNavTreePart( TQWidget* parent = 0L, const char* name = 0L );
	virtual ~KompareNavTreePart();

public:
	virtual bool openFile() { return false; };

public slots:
	void slotSetSelection( const Diff2::DiffModel* model, const Diff2::Difference* diff );
	void slotSetSelection( const Diff2::Difference* diff );
	void slotModelsChanged( const Diff2::DiffModelList* modelList );
	void slotKompareInfo( Kompare::Info* info );

signals:
	void selectionChanged( const Diff2::DiffModel* model, const Diff2::Difference* diff );
	void selectionChanged( const Diff2::Difference* diff );

private slots:
	void slotSrcDirTreeSelectionChanged ( TQListViewItem* item );
	void slotDestDirTreeSelectionChanged( TQListViewItem* item );
	void slotFileListSelectionChanged   ( TQListViewItem* item );
	void slotChangesListSelectionChanged( TQListViewItem* item );

	void slotApplyDifference( bool apply );
	void slotApplyAllDifferences( bool apply );
	void slotApplyDifference( const Diff2::Difference* diff, bool apply );

	void buildTreeInMemory();

private:
	void setSelectedDir( const Diff2::DiffModel* model );
	void setSelectedFile( const Diff2::DiffModel* model );
	void setSelectedDifference( const Diff2::Difference* diff );

	void buildDirectoryTree();

	TQString compareFromEndAndReturnSame( const TQString& string1, const TQString& string2 );
	void addDirToTreeView( enum Kompare::Target, const TQString& filename );

	TDEListViewItem* findDirInDirTree( const TDEListViewItem* parent, const TQString& dir );

//	TDEListViewItem* firstItem();
//	TDEListViewItem* lastItem();

private:
	TQSplitter*                         m_splitter;
	const Diff2::DiffModelList*        m_modelList;

	TQPtrDict<KChangeLVI>               m_diffToChangeItemDict;
	TQPtrDict<KFileLVI>                 m_modelToFileItemDict;
	TQPtrDict<KDirLVI>                  m_modelToSrcDirItemDict;
	TQPtrDict<KDirLVI>                  m_modelToDestDirItemDict;

	TDEListView*                         m_srcDirTree;
	TDEListView*                         m_destDirTree;
	TDEListView*                         m_fileList;
	TDEListView*                         m_changesList;

	KDirLVI*                           m_srcRootItem;
	KDirLVI*                           m_destRootItem;

	const Diff2::DiffModel*            m_selectedModel;
	const Diff2::Difference*           m_selectedDifference;

	TQString                            m_source;
	TQString                            m_destination;

	struct Kompare::Info*              m_info;
};

// These 3 classes are need to store the models into a tree so it is easier
// to extract the info we need for the navigation widgets

class KChangeLVI : public TDEListViewItem
{
public:
	KChangeLVI( TDEListView* parent, Diff2::Difference* diff );
	~KChangeLVI();
public:
	Diff2::Difference* difference() { return m_difference; };
	virtual int compare( TQListViewItem* item, int column, bool ascending ) const;

	void setDifferenceText();
private:
	Diff2::Difference* m_difference;
};

class KFileLVI : public TDEListViewItem
{
public:
	KFileLVI( TDEListView* parent, Diff2::DiffModel* model );
	~KFileLVI();
public:
	Diff2::DiffModel* model() { return m_model; };
	void fillChangesList( TDEListView* changesList, TQPtrDict<KChangeLVI>* diffToChangeItemDict );
private:
	Diff2::DiffModel* m_model;
};

class KDirLVI : public TDEListViewItem
{
public:
	KDirLVI( KDirLVI* parent, TQString& dir );
	KDirLVI( TDEListView* parent, TQString& dir );
	~KDirLVI();
public:
	void addModel( TQString& dir, Diff2::DiffModel* model, TQPtrDict<KDirLVI>* modelToDirItemDict );
	TQString& dirName() { return m_dirName; };
	TQString fullPath( TQString& path );
	KDirLVI* setSelected( TQString dir );
	void fillFileList( TDEListView* fileList, TQPtrDict<KFileLVI>* modelToFileItemDict );
	bool isRootItem() { return m_rootItem; };
private:
	KDirLVI* findChild( TQString dir );
private:
	Diff2::DiffModelList m_modelList;
	TQString m_dirName;
	bool m_rootItem;
};

// part stuff
class TDEInstance;
class TDEAboutData;

class KompareNavTreePartFactory : public KParts::Factory
{
	Q_OBJECT
  
public:
	KompareNavTreePartFactory();
	virtual ~KompareNavTreePartFactory();
	virtual KParts::Part* createPartObject( TQWidget *parentWidget, const char *widgetName,
	                                        TQObject *parent, const char *name,
	                                        const char *classname, const TQStringList &args );
	static TDEInstance* instance();

private:
	static TDEInstance* s_instance;
	static TDEAboutData* s_about;
};

#endif
