/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

**************************************************************************** */
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqlayout.h>

#include <tdefiledialog.h>
#include <tqpushbutton.h>
#include <tqwhatsthis.h>
#include <klineedit.h>
#include <tdelocale.h>
#include <kurlrequester.h>

#include "preferenceswidget.h"
#include "pwidget.h"

CompendiumPreferencesWidget::CompendiumPreferencesWidget(TQWidget *parent, const char* name)
		: PrefWidget(parent,name)
		, changed(false)
{
	TQVBoxLayout *layout = new TQVBoxLayout(this);
		
	prefWidget = new CompendiumPWidget(this);
	layout->addWidget(prefWidget);

	connect(prefWidget->caseBtn, TQT_SIGNAL(toggled(bool))
					, this, TQT_SLOT(setChanged()));
	connect(prefWidget->equalBtn, TQT_SIGNAL(toggled(bool))
					, this, TQT_SLOT(setChanged()));
	connect(prefWidget->ngramBtn, TQT_SIGNAL(toggled(bool))
					, this, TQT_SLOT(setChanged()));
	connect(prefWidget->isContainedBtn, TQT_SIGNAL(toggled(bool))
					, this, TQT_SLOT(setChanged()));
	connect(prefWidget->containsBtn, TQT_SIGNAL(toggled(bool))
					, this, TQT_SLOT(setChanged()));
	connect(prefWidget->fuzzyBtn, TQT_SIGNAL(toggled(bool))
					, this, TQT_SLOT(setChanged()));
	connect(prefWidget->hasWordBtn, TQT_SIGNAL(toggled(bool))
					, this, TQT_SLOT(setChanged()));
	connect(prefWidget->wholeBtn, TQT_SIGNAL(toggled(bool))
					, this, TQT_SLOT(setChanged()));
	
	connect(prefWidget->urlInput->lineEdit(),TQT_SIGNAL(textChanged(const TQString&))
					, this, TQT_SLOT(setChanged()));

	connect(prefWidget->equalBtn, TQT_SIGNAL(toggled(bool))
					, this, TQT_SLOT(equalBtnToggled(bool)));
	connect(prefWidget->ngramBtn, TQT_SIGNAL(toggled(bool))
					, this, TQT_SLOT(ngramBtnToggled(bool)));
	connect(prefWidget->isContainedBtn, TQT_SIGNAL(toggled(bool))
					, this, TQT_SLOT(isContainedBtnToggled(bool)));
	connect(prefWidget->containsBtn, TQT_SIGNAL(toggled(bool))
					, this, TQT_SLOT(containsBtnToggled(bool)));
	connect(prefWidget->hasWordBtn, TQT_SIGNAL(toggled(bool))
					, this, TQT_SLOT(hasWordBtnToggled(bool)));


	TQString whatsthis=i18n("<qt><p><b>Parameters</b></p>"
		"<p>Here you can fine-tune searching within the PO file. "
		"For example if you want to perform a case sensitive search, or if "
		"you want fuzzy messages to be ignored.</p></qt>" );
	TQWhatsThis::add(prefWidget->caseBtn,whatsthis);
	TQWhatsThis::add(prefWidget->fuzzyBtn,whatsthis);
	TQWhatsThis::add(prefWidget->wholeBtn,whatsthis);

	whatsthis = i18n("<qt><p><b>Comparison Options</b></p>"
		"<p>Choose here which messages you want to have treated as a matching "
		"message.</p></qt>");
	TQWhatsThis::add(prefWidget->equalBtn,whatsthis);
	TQWhatsThis::add(prefWidget->containsBtn,whatsthis);
	TQWhatsThis::add(prefWidget->isContainedBtn,whatsthis);
	TQWhatsThis::add(prefWidget->hasWordBtn,whatsthis);

	whatsthis = i18n("<qt><p><b>3-Gram-matching</b></p>"
			 "<p>A message matches another if most of its 3-letter groups are "
			 "contained in the other message. e.g. 'abc123' matches 'abcx123c12'.</p></qt>");
	TQWhatsThis::add(prefWidget->ngramBtn,whatsthis);

	whatsthis = i18n("<qt><p><b>Location</b></p>"
					"<p>Configure here which file is to be used for searching."
					"</p></qt>");
	TQWhatsThis::add(prefWidget->urlInput,whatsthis);
}

CompendiumPreferencesWidget::~CompendiumPreferencesWidget()
{
}


void CompendiumPreferencesWidget::apply()
{
	emit applySettings();
}

void CompendiumPreferencesWidget::cancel()
{
	emit restoreSettings();
}

void CompendiumPreferencesWidget::standard()
{
	prefWidget->urlInput->setURL("");
	prefWidget->caseBtn->setChecked(false);
	prefWidget->equalBtn->setChecked(true);
	prefWidget->ngramBtn->setChecked(true);
	prefWidget->isContainedBtn->setChecked(false);
	prefWidget->containsBtn->setChecked(false);
	prefWidget->wholeBtn->setChecked(true);
	prefWidget->hasWordBtn->setChecked(true);

	prefWidget->fuzzyBtn->setChecked(true);
	
	changed=true;
}

void CompendiumPreferencesWidget::setURL(const TQString url)
{
	prefWidget->urlInput->setURL(url);
	changed=false;
}

void CompendiumPreferencesWidget::setCaseSensitive(bool on)
{
	prefWidget->caseBtn->setChecked(on);
	changed=false;
}

void CompendiumPreferencesWidget::setMatchEqual(bool on)
{
	prefWidget->equalBtn->setChecked(on);
	changed=false;
}

void CompendiumPreferencesWidget::setMatchNGram(bool on)
{
	prefWidget->ngramBtn->setChecked(on);
	changed=false;
}

void CompendiumPreferencesWidget::setMatchIsContained(bool on)
{
	prefWidget->isContainedBtn->setChecked(on);
	changed=false;
}

void CompendiumPreferencesWidget::setMatchContains(bool on)
{
	prefWidget->containsBtn->setChecked(on);
	changed=false;
}

void CompendiumPreferencesWidget::setIgnoreFuzzy(bool on)
{
	prefWidget->fuzzyBtn->setChecked(on);
	changed=false;
}

void CompendiumPreferencesWidget::setWholeWords(bool on)
{
	prefWidget->wholeBtn->setChecked(on);
	changed=false;
}


void CompendiumPreferencesWidget::setMatchWords(bool on)
{
	prefWidget->hasWordBtn->setChecked(on);
	changed=false;
}



TQString CompendiumPreferencesWidget::url()
{
	changed=false;
	return prefWidget->urlInput->url();
}

bool CompendiumPreferencesWidget::caseSensitive()
{
	changed=false;

	return prefWidget->caseBtn->isChecked();
}

bool CompendiumPreferencesWidget::matchEqual()
{
	changed=false;

	return prefWidget->equalBtn->isChecked();
}

bool CompendiumPreferencesWidget::matchNGram()
{
	changed=false;

	return prefWidget->ngramBtn->isChecked();
}

bool CompendiumPreferencesWidget::matchIsContained()
{
	changed=false;

	return prefWidget->isContainedBtn->isChecked();
}

bool CompendiumPreferencesWidget::matchContains()
{
	changed=false;

	return prefWidget->containsBtn->isChecked();
}

bool CompendiumPreferencesWidget::ignoreFuzzy()
{
	changed=false;

	return prefWidget->fuzzyBtn->isChecked();
}


bool CompendiumPreferencesWidget::wholeWords()
{
	changed=false;

	return prefWidget->wholeBtn->isChecked();
}


bool CompendiumPreferencesWidget::matchWords()
{
	changed=false;

	return prefWidget->hasWordBtn->isChecked();
}



bool CompendiumPreferencesWidget::settingsChanged() const
{
	return changed;
}

void CompendiumPreferencesWidget::setChanged()
{
	changed=true;
}


void CompendiumPreferencesWidget::equalBtnToggled(bool on)
{
	if(!on)
	{
		if(!prefWidget->isContainedBtn->isChecked() 
		   && !prefWidget->ngramBtn->isChecked()
		   && !prefWidget->containsBtn->isChecked()
		   && !prefWidget->hasWordBtn->isChecked())
		{
			prefWidget->equalBtn->setChecked(true);
		}
	}
}

void CompendiumPreferencesWidget::ngramBtnToggled(bool on)
{
	if(!on)
	{
		if(!prefWidget->isContainedBtn->isChecked() 
		   && !prefWidget->equalBtn->isChecked()
		   && !prefWidget->containsBtn->isChecked()
		   && !prefWidget->hasWordBtn->isChecked())
		{
		  prefWidget->equalBtn->setChecked(true);
		}
	}
}

void CompendiumPreferencesWidget::isContainedBtnToggled(bool on)
{
	if(!on)
	{
		if(!prefWidget->equalBtn->isChecked() 
		   && !prefWidget->ngramBtn->isChecked()
		   && !prefWidget->containsBtn->isChecked()
		   && !prefWidget->hasWordBtn->isChecked())
		{
		  prefWidget->isContainedBtn->setChecked(true);
		}
	}
}

void CompendiumPreferencesWidget::containsBtnToggled(bool on)
{
	if(!on)
	{
		if(!prefWidget->isContainedBtn->isChecked() 
		   && !prefWidget->ngramBtn->isChecked()
		   && !prefWidget->equalBtn->isChecked()
		   && !prefWidget->hasWordBtn->isChecked())
		{
		  prefWidget->containsBtn->setChecked(true);
		}
	}
}

void CompendiumPreferencesWidget::hasWordBtnToggled(bool on)
{
	if(!on)
	{
		if(!prefWidget->isContainedBtn->isChecked() 
		   && !prefWidget->ngramBtn->isChecked()
		   && !prefWidget->equalBtn->isChecked()
		   && !prefWidget->containsBtn->isChecked())
		{
		  prefWidget->hasWordBtn->setChecked(true);
		}
	}
}



#include "preferenceswidget.moc"
