
#include "xparthost_kpart.h"

#include <dcopclient.h>
#include <dcopobject.h>
#include <tdeapplication.h>
#include <kstdaction.h>
#include <tdeaction.h>
#include <tdemainwindow.h>
#include <kprocess.h>
#include <tdeparts/mainwindow.h>
#include <kdebug.h>

class ShellWindow : public KParts::MainWindow
{
    Q_OBJECT

public:
    ShellWindow()
    {
        m_host = new XPartHost_KPart( this, "parthost" );

        setCentralWidget( m_host->widget() );

        connect(m_host, TQT_SIGNAL( actionsInitialized() ), this, TQT_SLOT( mergeGUI() ) );

#if 1
        m_partProcess = new TDEProcess;
        *m_partProcess << "./kmozilla"
                       << kapp->dcopClient()->appId() << m_host->objId();
        m_partProcess->start();
#endif

        KStdAction::quit( this, TQT_SLOT( close() ), actionCollection() );
        TDESelectAction *s = new TDESelectAction( "http://www.kde.org" , 0,
                           actionCollection(), "location" );
        connect( s, TQT_SIGNAL(activated( const TQString& ) ), this, TQT_SLOT( slotOpenUrl( const TQString & ) ) );
        s->setEditable(true);
    }
    virtual ~ShellWindow()
    {
        delete m_partProcess;
    }
public slots:
    void slotOpenUrl( const TQString &url )
    {
        kdDebug() << "this=" << this;
        kdDebug() << "url=" << url << endl;
        m_host->openURL(url.latin1());
    }
    void mergeGUI()
    {
        tqDebug("initGUI");
        setXMLFile("/home/lars/kmozilla/kmozilla/parthost.rc");
        createGUI( m_host );
    }

private:
    XPartHost_KPart *m_host;
    TDEProcess *m_partProcess;
};

int main( int argc, char **argv )
{
    TDEApplication app( argc, argv, "xtdepartsshell" );

    app.dcopClient()->registerAs("kshell");

    ShellWindow *w = new ShellWindow;
    w->resize(500, 500);
    w->show();

    return app.exec();
}

#include "kshell.moc"
