// Qt# tutorial 3
// Based on the Qt tutorial
// Implemented by Marcus Urban

using System;
using Qt;


public class Example {

	public static int Main (String[] args)
	{
		TQApplication a = new TQApplication (args);
		
		TQVBox box = new TQVBox ();
		box.Resize (200, 120);
		
		TQPushButton quit = new TQPushButton ("Quit", box);
		quit.SetFont (new TQFont ("Times", 18, TQFont.Weight.Bold));
		// In C++, TQFont::Bold is sufficient
		
		TQObject.Connect ( quit, QtSupport.TQT_SIGNAL ("clicked()"), a, QtSupport.TQT_SLOT ("Quit()") );
		// TQT_SIGNAL and TQT_SLOT are static functions of QtSupport
				
		a.SetMainWidget (box);
		box.Show ();
		return a.Exec ();
	}
}
