// Qt# tutorial 2
// Based on the Qt tutorial
// Implemented by Marcus Urban

using System;
using Qt;

public class Example {

	public static int Main (String[] args)
	{
		TQApplication a = new TQApplication (args);
		
		TQPushButton quit = new TQPushButton ("Quit", null);
		// In C++, the second parameter is 0 (null pointer)
		
		quit.Resize (75, 30);
		quit.SetFont (new TQFont ("Times", 18, TQFont.Weight.Bold));
		// In C++, TQFont::Bold is sufficient
		
		TQObject.Connect ( quit, QtSupport.TQT_SIGNAL ("clicked()"), a, QtSupport.TQT_SLOT ("Quit()") );
		// TQT_SIGNAL and TQT_SLOT are static functions of QtSupport
		
		a.SetMainWidget (quit);
		quit.Show ();
		return a.Exec ();
	}
}
