namespace QtSamples {

	using Qt;
	using System;

	public class Display : TQMainWindow {

		private TextArea textarea;
		private TQScrollView scrollview;
		private TQMenuBar menubar;
		private TQPopupMenu filemenu, aboutmenu;

		private class TextArea : TQTextEdit {

			public TextArea (TQWidget parent) : base (parent)
			{
				TQFile file = new TQFile ("display.cs");
				if ( file.Open(1) ) {
					TQTextStream ts = new TQTextStream (file);
					this.SetText (ts.Read ());
					this.SetTabStopWidth (30);
				}
			}
		}

		public Display ()
		{
			filemenu = new TQPopupMenu (null, "filemenu");
			filemenu.InsertItem	("&Quit", tqApp, TQT_SLOT ("quit()"));

			aboutmenu = new TQPopupMenu(null, "aboutmenu");
			aboutmenu.InsertItem("&About Qt-Sharp", this, TQT_SLOT("slotAbout()"));

			menubar = new TQMenuBar(this, "");
			menubar.InsertItem("&File", filemenu);
			menubar.InsertItem("&About", aboutmenu);

			textarea = new TextArea (this);
			textarea.SetGeometry(0, menubar.Height(), Width(), Height() - menubar.Height());
			this.SetCentralWidget (textarea);
		}

		public void slotAbout ()
		{
			TQMessageBox.Information (
				this, "About Qt-Sharp-0.7",
					  "A Qt (http://www.trolltech.com) to C# language binding.\n" +
					  "Qt-Sharp is compatible with Mono (http://go-mono.org) and\n" +
					  "Portable.NET (http://www.southern-storm.com.au/portable_net.html)\n" +
					  "(c) 2002 Adam Treat. Licensed under the terms of the GNU GPL.\n"
				);
		}

		public static void Main (String[] args)
		{
			TQApplication app = new TQApplication (args);
			Display demo = new Display ();
			demo.SetCaption ("Qt-Sharp-0.7!");
			app.SetMainWidget (demo);
			demo.Show ();
			app.Exec ();
			return;
		}
	}
}
