/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.trinitydesktop.qt.*;


class ListenDND  extends TQObject
{

public  ListenDND( TQWidget w )
    {view = w;}

    void dropped( TQDropEvent mime ) {
        tqDebug( "Dropped Mimesource {0} into the view {1}", new Object[] { mime, view } );
        tqDebug( "  Formats:" );
        int i = 0;
        String str = mime.format( i );
        tqDebug( "    " + str );
        while ( str != null ) {
            tqDebug( "    " + str );
            str = mime.format( ++i );
        }
    };
    void moved() {
        tqDebug( "All selected items were moved to another widget" );
    }

protected TQWidget view;


public static void main( String[] args )
{
    TQApplication a = new TQApplication( args );

    TQIconView qiconview = new TQIconView();
    qiconview.setSelectionMode( TQIconView.Extended );

    for ( int i = 0; i < 3000; i++ ) {
	TQIconViewItem item = new TQIconViewItem( qiconview, "Item " + (i + 1) );
	item.setRenameEnabled( true );
    }

    qiconview.setCaption( "Qt Example - Iconview" );

    ListenDND listen_dnd = new ListenDND( qiconview );
    TQObject.connect( qiconview, SIGNAL(" dropped( TQDropEvent , ArrayList )"),
		      listen_dnd, SLOT(" dropped( TQDropEvent  )") );
    TQObject.connect( qiconview, SIGNAL(" moved()"), listen_dnd, SLOT(" moved()") );

    a.setMainWidget( qiconview );
    qiconview.show();
    qiconview.resize( qiconview.sizeHint() );

    a.exec();
    return;
}

static {
	qtjava.initialize();
}

}

