/***************************************************************************
* $Id$
**
* Definition of something or other
**
* Created : 979899
**
* Copyright (C) 1997 by Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.trinitydesktop.qt.*;
import java.util.Random;



class Forever  extends TQWidget
{
static final int numColors = 120;

private    int		rectangles;
private    TQColor[]	colors = new TQColor[numColors];
private    Random generator = new Random(System.currentTimeMillis());



//
// Forever - a widget that draws rectangles forever.
//

//
// Constructs a Forever widget.
//
Forever( )
{
	this(null, null);
}

Forever( TQWidget parent, String name )
{
    super( parent, name );
    for (int a=0; a<numColors; a++) {
	colors[a] = new TQColor( generator.nextInt(255),
			    generator.nextInt(255),
			    generator.nextInt(255) );
    }
    rectangles = 0;
    startTimer( 0 );				// run continuous timer
    TQTimer  counter = new TQTimer( this );
    connect( counter, SIGNAL("timeout()"),
	     this, SLOT("updateCaption()") );
    counter.start( 1000 );
}


void updateCaption()
{
    String s = "Qt Example - Forever - " + rectangles + " rectangles/second";
    rectangles = 0;
    setCaption( s );
}


//
// Handles paint events for the Forever widget.
//

protected void paintEvent( TQPaintEvent e  )
{
    TQPainter paint = new TQPainter( this );			// painter object
    int w = width();
    int h = height();
    if(w <= 0 || h <= 0) 
	return;
    paint.setPen( NoPen );			// do not draw outline
    paint.setBrush( colors[generator.nextInt(numColors)]);// set random brush color
    
//    TQPoint p1 = new TQPoint( generator.nextInt(w), generator.nextInt(h));	// p1 = top left
//    TQPoint p2 = new TQPoint( generator.nextInt(w), generator.nextInt(h));	// p2 = bottom right
    
//    TQRect r = new TQRect( p1, p2 );
//    paint.drawRect( r );			// draw filled rectangle
    paint.drawRect( generator.nextInt(w), generator.nextInt(h),
					generator.nextInt(w), generator.nextInt(h) );			// draw filled rectangle
}

//
// Handles timer events for the Forever widget.
//

protected void timerEvent( TQTimerEvent e )
{
    for ( int i=0; i<100; i++ ) {
	repaint( false );			// repaint, don't erase
	rectangles++;
    }
}


//
// Create and display Forever widget.
//

public static void main( String[] args )
{
    TQApplication a = new TQApplication( args );		// create application object
    Forever always = new Forever();				// create widget
    a.setMainWidget( always );			// set as main widget
    always.setCaption("Qt Example - Forever");
    always.show();				// show widget
    a.exec();				// run event loop
	return;
}

static {
	qtjava.initialize();
}
}
