/***************************************************************************
* $Id$
**
* Drop site example implementation
**
* Created : 979899
**
* Copyright (C) 1997 by Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.trinitydesktop.qt.*;
import java.util.*;


class DropSite extends TQLabel
{
	SecretSource s;

void setSecretSource(SecretSource source)
{
	s = source;
}

DropSite( TQWidget  parent )
{
	this(parent, null);
}

DropSite( TQWidget  parent, String  name )
{
    super( parent, name );
    setAcceptDrops(true);
}


{
    // nothing necessary
}


protected void dragMoveEvent( TQDragMoveEvent  e )
{
    // Check if you want the drag at e.pos()...
    // Give the user some feedback...
}


protected void dragEnterEvent( TQDragEnterEvent e )
{
    // Check if you want the drag...
    if ( SecretDrag.canDecode( e )
      || TQTextDrag.canDecode( e )
      || TQImageDrag.canDecode( e )
      || TQUriDrag.canDecode( e ) ) {
	e.accept();
	}

    // Give the user some feedback...
    String t = "";
    for( int i=0; e.format( i ) != null; i++ ) {
		t += "\n";
	    t += e.format( i );
    }
    emit("message", t );
    setBackgroundColor(white());
}

protected void dragLeaveEvent( TQDragLeaveEvent e  )
{
    // Give the user some feedback...
    emit("message", "");
    setBackgroundColor(lightGray());
}


protected void dropEvent( TQDropEvent  e )
{
    setBackgroundColor(lightGray());

    // Try to decode to the data you understand...

    StringBuffer str = new StringBuffer("");
	if ( TQTextDrag.decode( e, str ) ) {
	setText( str.toString() );
	setMinimumSize( minimumSize().expandedTo( sizeHint() ) );
	return;
    }

    TQPixmap pm = new TQPixmap();
    if ( TQImageDrag.decode( e, pm ) ) {
	setPixmap( pm );
	setMinimumSize( minimumSize().expandedTo( sizeHint() ) );
	return;
    }

	ArrayList strings = new ArrayList();
    if ( TQUriDrag.decode( e, strings ) ) {
	String m = "Full URLs:\n";
	Iterator it = strings.iterator();
	while (it.hasNext())
		m += "   " + (String) it.next() + "\n";
	ArrayList files = new ArrayList();
	if ( TQUriDrag.decodeLocalFiles( e, files ) ) {
	    m = m + "Files:\n";
		Iterator i = strings.iterator();
		while (i.hasNext())
		m = m + "   " + (String) i.next() + "\n";
	}
	setText( m );
	setMinimumSize( minimumSize().expandedTo( sizeHint() ) );
	return;
    }

    if ( SecretDrag.decode( e, str ) ) {
	setText( str.toString() );
	setMinimumSize( minimumSize().expandedTo( sizeHint() ) );
	return;
    }
}

protected void mousePressEvent( TQMouseEvent  e )
{
    TQDragObject drobj;
    if ( pixmap() != null ) {
	drobj = new TQImageDrag( pixmap().convertToImage(), this );
	TQPixmap pm = new TQPixmap();
	pm.convertFromImage(pixmap().convertToImage().smoothScale(
	    pixmap().width()/3,pixmap().height()/3));
	drobj.setPixmap(pm,new TQPoint(-5,-7));
	// Try it.
//	new DragMoviePlayer(drobj);
    } else {
	drobj = new TQTextDrag( text(), this );
    }
    drobj.dragCopy();
}

class DragMoviePlayer extends TQObject {
    TQDragObject dobj;
    TQMovie movie;

DragMoviePlayer( TQDragObject p )
{
//    TQObject(p),
    dobj = p;
    movie = new TQMovie("trolltech.gif" );
    movie.connectUpdate(this,SLOT("updatePixmap(TQRect)"));
}

void updatePixmap( TQRect rect )
{
    dobj.setPixmap(movie.framePixmap());
}


}

void backgroundColorChange( TQColor color )
{
    // Reduce flicker by using repaint() rather than update()
    repaint();
}

}
