/*
  Model for winamp skins
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */

#ifndef __WASKINMODEL_H
#define __WASKINMODEL_H

#include <tqstring.h>
#include <tqobject.h>
#include <tqdir.h>

#include "waSkins.h"

enum skin_models { WA_MODEL_NORMAL, WA_MODEL_WINDOWSHADE };

class TQChar;
class WaSkinModel;
extern WaSkinModel *_waskinmodel_instance;

class WaSkinModel : public TQObject {
  Q_OBJECT
  

  public:
     WaSkinModel();
    ~WaSkinModel();

    void getDigit(char number, TQPaintDevice *dest, int x, int y);
    void getText(char text, TQPaintDevice *dest, int x, int y);

    void bltTo(int id, TQPaintDevice *dest, int x, int y);
    void bltTo(int id, TQPaintDevice *dest, int x, int y, int argument);

    void paintBackgroundTo(int mapping, TQPaintDevice *dest, int x, int y);

    TQRect getGeometry(int id);
    TQRect getMapGeometry(int id);

    bool load(TQString skinDir);

    void setSkinModel(skin_models new_model);
    static WaSkinModel *instance() { return _waskinmodel_instance; }
 
  private:
    void resetSkinModel();

    TQString findFile(const TQDir &dir, const TQString &filename);
    TQChar deaccent(TQChar input);

    int getPixmap(const TQDir &dir, TQString fname, TQPixmap * target);
    void loadColors(const TQDir &dir);
    void loadRegion(const TQDir &dir);
 
  signals:
    void skinChanged(); 
};
#endif
