#ifndef KJTEXTDISPLAY_H
#define KJTEXTDISPLAY_H

#include "kjwidget.h"
class KJLoader;
class KPixmap;
//#include "kjloader.h"

#include <tqobject.h>
#include <tqpainter.h>

class KJFilename : public TQObject, public KJWidget
{
Q_OBJECT
  
public:
	KJFilename(const TQStringList &, KJLoader *parent);
	~KJFilename();

	virtual void paint(TQPainter *, const TQRect &rect);
	virtual bool mousePress(const TQPoint &pos);
	virtual void mouseRelease(const TQPoint &, bool in);
//	virtual void newFile();
	virtual void timeUpdate(int);
	virtual void readConfig();

	void prepareString(const TQCString &str);
	virtual TQString tip();

	virtual void timerEvent(TQTimerEvent *);

private:
	TQCString mLastTitle;
	int mDistance;
	int mTimerUpdates;
	int mWidth;
	int mTickerPos;
	TQPixmap mView;
	KPixmap *mBack;
};


class KJTime : public KJWidget
{
public:
	KJTime(const TQStringList &, KJLoader *parent);
	~KJTime();

	virtual void paint(TQPainter *, const TQRect &rect);
	virtual bool mousePress(const TQPoint &pos);
	virtual void mouseRelease(const TQPoint &, bool in);
	virtual void timeUpdate(int);
	virtual void readConfig();

	void prepareString(const TQCString &time);
	virtual TQString tip();

//	enum countModes { Up=0, Down };

private:
	TQCString mLastTime;
	int mWidth;
	bool countDown;
	TQPixmap mTime;
	KPixmap *mBack;

private:
	TQString lengthString ( void );

};


class KJVolumeText : public KJWidget
{
public:
	KJVolumeText(const TQStringList &, KJLoader *parent);
	~KJVolumeText();

	virtual void paint(TQPainter *, const TQRect &rect);
	virtual bool mousePress(const TQPoint &pos);
	virtual void timeUpdate(int);
	virtual void readConfig();

	void prepareString(const TQCString &time);
	virtual TQString tip();

private:
	TQCString mLastVolume;
	int mWidth;
	TQPixmap mVolume;
	KPixmap *mBack;
};


class KJPitchText : public KJWidget
{
public:
	KJPitchText(const TQStringList &, KJLoader *parent);
	~KJPitchText();

	virtual void paint(TQPainter *, const TQRect &rect);
	virtual bool mousePress(const TQPoint &pos);
	virtual void mouseRelease(const TQPoint &, bool in);
	virtual void timeUpdate(int);
	virtual void readConfig();

	void prepareString(const TQCString &time);
	virtual TQString tip();

private:
	TQCString mLastPitch;
	int mWidth;
	TQPixmap mSpeed;
	KPixmap *mBack;
};


class KJFileInfo : public KJWidget
{
public:
	KJFileInfo(const TQStringList &, KJLoader *parent);
	~KJFileInfo();

	virtual void paint(TQPainter *, const TQRect &rect);
	virtual bool mousePress(const TQPoint &pos);
	virtual void timeUpdate(int);
	virtual void readConfig();

	void prepareString(const TQCString &time);
	virtual TQString tip();

private:
	TQCString mLastTime;
	TQString mInfoType;
	int mWidth;
	TQPixmap mTime;
	KPixmap *mBack;
};

#endif
