/***************************************************************************
    copyright            : (C) 2003 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef KREC_EXPORT_MP3_H
#define KREC_EXPORT_MP3_H

#include "krecexport_template.h"

#include <lame/lame.h>

class KTempFile;
class TQFile;

class KRecExport_MP3 : public KRecExportItem {
   Q_OBJECT
  
public:
	KRecExport_MP3( TQObject*, const char* =0, const TQStringList& =0 );
	~KRecExport_MP3();

	KRecExport_MP3* newItem();

	TQStringList extensions();
	TQString exportFormat() { return TQString( "Wave" ); }
public slots:
	bool initialize( const TQString & );
	bool process();
	bool finalize();

private:
	TQFile* _file;
	// Lame MP3 encoder
	void setLameParameters();
	lame_global_flags *gfp;
	unsigned char mp3buf[ LAME_MAXMP3BUFFER ];
	bool error_occurred;
	bool write_id3;
	bool init_done;
};

#endif
