/*
 * KMix -- KDE's full featured mini mixer
 *
 *
 * Copyright (C) 2000 Stefan Schimanski <1Stein@gmx.de>
 * Copyright (C) 2001 Preston Brown <pbrown@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <tqbuttongroup.h>
#include <tqlayout.h>
#include <tqwhatsthis.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqradiobutton.h>

#include <tdelocale.h>
// For "kapp"
#include <tdeapplication.h>

#include "kmix.h"
#include "kmixprefdlg.h"
#include "kmixerwidget.h"


KMixPrefDlg::KMixPrefDlg( TQWidget *parent )
    : KDialogBase(  Plain, i18n( "Configure" ),
          Ok|Cancel|Apply, Ok, parent )
{
   // general buttons
   m_generalTab = plainPage( /* i18n("&General") */ );

   TQBoxLayout *layout = new TQVBoxLayout( m_generalTab );
   layout->setSpacing( KDialog::spacingHint() );

   m_dockingChk = new TQCheckBox( i18n("&Dock into panel"), m_generalTab );
   layout->addWidget( m_dockingChk );
   TQWhatsThis::add(m_dockingChk, i18n("Docks the mixer into the TDE panel"));

   m_volumeChk = new TQCheckBox(i18n("Enable system tray &volume control"),
			       m_generalTab);
   layout->addWidget(m_volumeChk);

   m_showTicks = new TQCheckBox( i18n("Show &tickmarks"), m_generalTab );
   layout->addWidget( m_showTicks );
   TQWhatsThis::add(m_showTicks,
           i18n("Enable/disable tickmark scales on the sliders"));

   m_showLabels = new TQCheckBox( i18n("Show &labels"), m_generalTab );
   layout->addWidget( m_showLabels );
   TQWhatsThis::add(m_showLabels,
           i18n("Enables/disables description labels above the sliders"));


   m_onLogin = new TQCheckBox( i18n("Restore volumes on login"), m_generalTab );
   layout->addWidget( m_onLogin );

   m_dockIconMuting = new TQCheckBox( 
            i18n("Middle click on system tray icon toggles muting"), m_generalTab );
   layout->addWidget( m_dockIconMuting );

   TQBoxLayout *numbersLayout = new TQHBoxLayout( layout );
   TQButtonGroup *numbersGroup = new TQButtonGroup( 3, Qt::Horizontal, i18n("Numbers"), m_generalTab );
   numbersGroup->setRadioButtonExclusive(true);
   TQLabel* qlbl = new TQLabel(  i18n("Volume Values: "), m_generalTab );
   _rbNone = new TQRadioButton( i18n("&None"), m_generalTab );
   _rbAbsolute = new TQRadioButton( i18n("A&bsolute"), m_generalTab );
   _rbRelative   = new TQRadioButton( i18n("&Relative"), m_generalTab );
   numbersGroup->insert(_rbNone);
   numbersGroup->insert(_rbAbsolute);
   numbersGroup->insert(_rbRelative);
   numbersGroup->hide();

   numbersLayout->add(qlbl);
   numbersLayout->add(_rbNone);
   numbersLayout->add(_rbAbsolute);
   numbersLayout->add(_rbRelative);
   numbersLayout->addStretch();

   m_autoStartChk = new TQCheckBox( i18n("&Autostart"), m_generalTab );
   layout->addWidget( m_autoStartChk );
   TQWhatsThis::add(m_autoStartChk, i18n("Automatically start mixer when you login"));

   TQBoxLayout *orientationLayout = new TQHBoxLayout( layout );
   TQButtonGroup* orientationGroup = new TQButtonGroup( 2, Qt::Horizontal, i18n("Orientation"), m_generalTab );
   //orientationLayout->add(orientationGroup);
   orientationGroup->setRadioButtonExclusive(true);
   TQLabel* qlb = new TQLabel( i18n("Slider Orientation: "), m_generalTab );
   _rbHorizontal = new TQRadioButton(i18n("&Horizontal"), m_generalTab );
   _rbVertical   = new TQRadioButton(i18n("&Vertical"  ), m_generalTab );
   orientationGroup->insert(_rbHorizontal);
   orientationGroup->insert(_rbVertical);
   orientationGroup->hide();
   //orientationLayout->add(qlb);
   //orientationLayout->add(orientationGroup);

   orientationLayout->add(qlb);
   orientationLayout->add(_rbHorizontal);
   orientationLayout->add(_rbVertical);

   orientationLayout->addStretch();
   layout->addStretch();
   enableButtonSeparator(true);

   connect( this, TQT_SIGNAL(applyClicked()), this, TQT_SLOT(apply()) );
   connect( this, TQT_SIGNAL(okClicked()), this, TQT_SLOT(apply()) );
}

KMixPrefDlg::~KMixPrefDlg()
{
}

void KMixPrefDlg::apply()
{
   // disabling buttons => users sees that we are working
   enableButtonOK(false);
   enableButtonCancel(false);
   enableButtonApply(false);
   kapp->processEvents();
   emit signalApplied( this );
   // re-enable (in case of "Apply")
   enableButtonOK(true);
   enableButtonCancel(true);
   enableButtonApply(true);
}

#include "kmixprefdlg.moc"
