/***************************************************************************
    begin                : Sun May 15 2005 
    copyright            : (C) 2005 by Michael Pyne
    email                : michael.pyne@kdemail.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdelistview.h>
#include <kiconview.h>
#include <kiconviewsearchline.h>
#include <kiconloader.h>
#include <tdeapplication.h>
#include <tdepopupmenu.h>
#include <tdelocale.h>

#include <tqtimer.h>
#include <tqtoolbutton.h>

#include "coverdialog.h"
#include "covericonview.h"
#include "covermanager.h"
#include "collectionlist.h"

using CoverUtility::CoverIconViewItem;

class AllArtistsListViewItem : public TDEListViewItem
{
public:
    AllArtistsListViewItem(TQListView *parent) :
        TDEListViewItem(parent, i18n("<All Artists>"))
    {
    }

    int compare(TQListViewItem *, int, bool) const
    {
        return -1; // Always be at the top.
    }
};

class CaseInsensitiveItem : public TDEListViewItem
{
public:
    CaseInsensitiveItem(TQListView *parent, const TQString &text) :
        TDEListViewItem(parent, text)
    {
    }

    int compare(TQListViewItem *item, int column, bool ascending) const
    {
        Q_UNUSED(ascending);
        return text(column).lower().localeAwareCompare(item->text(column).lower());
    }
};

CoverDialog::CoverDialog(TQWidget *parent) :
    CoverDialogBase(parent, "juk_cover_dialog", WType_Dialog)
{
    m_covers->setResizeMode(TQIconView::Adjust);
    m_covers->setGridX(140);
    m_covers->setGridY(150);

    m_searchLine->setIconView(m_covers);
    m_clearSearch->setIconSet(SmallIconSet("locationbar_erase"));
}

CoverDialog::~CoverDialog()
{
}

void CoverDialog::show()
{
    m_artists->clear();
    m_covers->clear();

    TQStringList artists = CollectionList::instance()->uniqueSet(CollectionList::Artists);

    m_artists->setSorting(-1);
    new AllArtistsListViewItem(m_artists);
    for(TQStringList::ConstIterator it = artists.begin(); it != artists.end(); ++it)
        new CaseInsensitiveItem(m_artists, *it);

    m_artists->setSorting(0);

    TQTimer::singleShot(0, this, TQT_SLOT(loadCovers()));
    CoverDialogBase::show();
}

// Here we try to keep the GUI from freezing for too long while we load the
// covers.
void CoverDialog::loadCovers()
{
    TQValueList<coverKey> keys = CoverManager::keys();
    TQValueList<coverKey>::ConstIterator it;
    int i = 0;

    for(it = keys.begin(); it != keys.end(); ++it) {
        new CoverIconViewItem(*it, m_covers);

        if(++i == 10) {
            i = 0;
            kapp->processEvents();
        }
    }
}

// TODO: Add a way to show cover art for tracks with no artist.
void CoverDialog::slotArtistClicked(TQListViewItem *item)
{
    m_covers->clear();

    if(dynamic_cast<AllArtistsListViewItem *>(item)) {
        // All artists.
        loadCovers();
    }
    else {
        TQString artist = item->text(0).lower();
        TQValueList<coverKey> keys = CoverManager::keys();
        TQValueList<coverKey>::ConstIterator it;

        for(it = keys.begin(); it != keys.end(); ++it) {
            CoverDataPtr data = CoverManager::coverInfo(*it);
            if(data->artist == artist)
                new CoverIconViewItem(*it, m_covers);
        }
    }
}

void CoverDialog::slotContextRequested(TQIconViewItem *item, const TQPoint &pt)
{
    static TDEPopupMenu *menu = 0;

    if(!item)
        return;

    if(!menu) {
        menu = new TDEPopupMenu(this);
        menu->insertItem(i18n("Remove Cover"), this, TQT_SLOT(removeSelectedCover()));
    }

    menu->popup(pt);
}

void CoverDialog::removeSelectedCover()
{
    CoverIconViewItem *coverItem = m_covers->currentItem();

    if(!coverItem || !coverItem->isSelected()) {
        kdWarning(65432) << "No item selected for removeSelectedCover.\n";
        return;
    }

    if(!CoverManager::removeCover(coverItem->id()))
        kdError(65432) << "Unable to remove selected cover: " << coverItem->id() << endl;
    else
        delete coverItem;
}

#include "coverdialog.moc"
