/*

    Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    */

#include "midiinstdlg.h"
#include <tdelocale.h>
#include <kstandarddirs.h>

#include <tdeapplication.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqfile.h>
#include <tqdir.h>
#include <kbuttonbox.h>
#include <kseparator.h>
#include <kdebug.h>
#include <tqbutton.h>
#include <tqpushbutton.h>
#include <kstdguiitem.h>

static TQStringList getArtsPath()
{
    TQStringList artsPath;
	TQString dir = locate("data", "artsbuilder/examples/");
	artsPath += dir;
    TQString home = TQDir::homeDirPath() + "/arts/structures/";
    artsPath += home;
	return artsPath;
}

static TQStringList listFiles(TQString directory, TQString extension)
{
	TQStringList result;
    TQStringList artsPath = getArtsPath();

    TQStringList::Iterator it;
    for ( it = artsPath.begin(); it != artsPath.end(); it++ ) {
        TQString pathname = *it + "/" + directory;
        TQDir dir(pathname, extension);
        if (dir.exists()) {
            //kdDebug() << "found dir " << dir.absPath() << endl;
            result += dir.entryList();
        }
    }

	return result;
}

MidiInstDlg::MidiInstDlg(TQWidget *parent)
	:TQDialog(parent,"instrument",TRUE)
{
	TQVBoxLayout *mainlayout = new TQVBoxLayout(this);

// caption label: title

	mainlayout->addSpacing(5);
	TQLabel *captionlabel = new TQLabel(this);
	TQFont labelfont(captionlabel->font());
	labelfont.setPointSize(labelfont.pointSize()*3/2);
	captionlabel->setFont(labelfont);
	captionlabel->setText(TQString(" ")+i18n("Instrument")+TQString(" "));
	captionlabel->setAlignment(AlignCenter);
	//min_size(captionlabel);
	mainlayout->addWidget(captionlabel);

// hruler

	mainlayout->addSpacing(5);
	KSeparator *ruler2 = new KSeparator( KSeparator::HLine, this);
	mainlayout->addWidget(ruler2);
	mainlayout->addSpacing(5);

// combobox

	box = new TQComboBox(this);

    TQStringList instruments = listFiles(".","*.arts");
    TQStringList::Iterator it;
    for ( it = instruments.begin(); it != instruments.end(); it++ ) {
        TQString modname = *it;
        TQString prefix = TQString::fromLatin1("instrument_");
        if (modname.length() > 5)
            modname.truncate(modname.length()-5);  // kill .arts extension
        if ( (modname.startsWith(prefix)) && (!modname.contains("_GUI")) )
            box->insertItem(modname.mid(prefix.length()));
            //kdDebug() << "inserted instrument: " << modname.mid(prefix.length()) << endl;
    }


    TQStringList maps = listFiles(".","*.arts-map");

    for ( it = maps.begin(); it != maps.end(); it++ ) {
        TQString modname = *it;
        TQString prefix = TQString::fromLatin1("instrument_");
        if (modname.length() > 9)
            modname.truncate(modname.length()-9);  // kill .arts-map extension
        if (modname.startsWith(prefix))
            box->insertItem(modname.mid(prefix.length()));
            //kdDebug() << "inserted map: " << modname.mid(prefix.length()) << endl;
    }

	mainlayout->addWidget(box);

// hruler

	mainlayout->addSpacing(5);
	KSeparator *ruler = new KSeparator( KSeparator::HLine, this);
	mainlayout->addWidget(ruler);
	mainlayout->addSpacing(5);

// buttons

	TQHBoxLayout *buttonlayout = new TQHBoxLayout;
	mainlayout->addSpacing(5);
	mainlayout->addLayout(buttonlayout);
	mainlayout->addSpacing(5);

	buttonlayout->addSpacing(5);
	KButtonBox *bbox = new KButtonBox(this);

	bbox->addButton(KStdGuiItem::help(), TQT_TQOBJECT(this), TQT_SLOT( help() ));
	bbox->addStretch(1);

	TQButton *okbutton = bbox->addButton(KStdGuiItem::ok());
	connect( okbutton, TQT_SIGNAL( clicked() ), TQT_SLOT(accept() ) );

	bbox->layout();

	buttonlayout->addWidget(bbox);
	buttonlayout->addSpacing(5);

	mainlayout->freeze();
}

TQCString MidiInstDlg::filename()
{
    TQStringList artsPath = getArtsPath();
	TQString instrument = box->currentText();

    TQStringList::Iterator it;

    for ( it = artsPath.begin(); it != artsPath.end(); it++ ) {
        TQString pathname = *it + TQString::fromLatin1("/instrument_") + instrument + TQString::fromLatin1(".arts");
        TQFileInfo fi(pathname);
        if (fi.exists() && fi.isReadable())
            return TQFile::encodeName(pathname);

        pathname = *it + TQString::fromLatin1("/instrument_") + instrument + TQString::fromLatin1(".arts-map");
        fi.setFile(pathname);
        if (fi.exists() && fi.isReadable())
            return TQFile::encodeName(pathname);
    }

	return "";
}

void MidiInstDlg::help()
{
	TDEApplication::kApplication()->invokeHelp("", "artsbuilder");
}

#include "midiinstdlg.moc"
