/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#ifndef TQT_TQSTRINGLIST_H
#define TQT_TQSTRINGLIST_H

#include <tqt.h>

#ifdef USE_QT3

// Reimplement the TQStringList class
// For Qt3, no changes are needed

#include <ntqstringlist.h>

#endif // USE_QT3

#ifdef USE_QT4

// Reimplement the TQStringList class
// For Qt4, some changes are needed

#include <ntqvaluelist.h>
#include <ntqstrlist.h>
#include <ntqtl.h>
#include <Qt/ntqstringlist.h>

/****************************************************************************
**
** Definition of TQStringList class
**
** Created : 990406
**
** Copyright (C) 1992-2008 Trolltech ASA.  All rights reserved.
**
** This file is part of the tools module of the Qt GUI Toolkit.
**
** This file may be used under the terms of the GNU General
** Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the files LICENSE.GPL2
** and LICENSE.GPL3 included in the packaging of this file.
** Alternatively you may (at your option) use any later version
** of the GNU General Public License if such license has been
** publicly approved by Trolltech ASA (or its successors, if any)
** and the KDE Free Qt Foundation.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/.
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** This file may be used under the terms of the Q Public License as
** defined by Trolltech ASA and appearing in the file LICENSE.QPL
** included in the packaging of this file.  Licensees holding valid Qt
** Commercial licenses may use this file in accordance with the Qt
** Commercial License Agreement provided with the Software.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not granted
** herein.
**
**********************************************************************/

#ifndef TQT_NO_STRINGLIST

class QRegExp;
template <class T> class QDeepCopy;

#if defined(Q_TEMPLATEDLL)
// MOC_SKIP_BEGIN
//Q_TEMPLATE_EXTERN template class Q_EXPORT TQValueList<QString>; 
// MOC_SKIP_END
#endif

class TQStringList : public TQValueList<QString>
{
public:
    TQStringList() { }
    TQStringList( const TQStringList& l ) : TQValueList<QString>(l) { }
    TQStringList( const TQValueList<QString>& l ) : TQValueList<QString>(l) { }
    TQStringList( const QString& i ) { append(i); }
#ifndef TQT_NO_CAST_ASCII
    TQStringList( const char* i ) { append(i); }
#endif

    // Interoperability
    TQStringList(const QStringList& l)
    {
        for (int i = 0; i < l.size(); ++i) append(l.at(i));
    }

    TQStringList& operator= (const QStringList& l)
    {
        this->clear();
        for (int i = 0; i < l.size(); ++i) append(l.at(i));
        return *this;
    }

    operator QStringList() const {
        QStringList list;
        for (TQStringList::const_iterator it = TQStringList::constBegin();
             it != TQStringList::constEnd(); ++it)
            list.append(*it);
        return list;
    }

    static TQStringList fromStrList(const TQStrList&);

    void sort();

    static TQStringList split( const QString &sep, const QString &str, bool allowEmptyEntries = FALSE );
    static TQStringList split( const QChar &sep, const QString &str, bool allowEmptyEntries = FALSE );
#ifndef TQT_NO_REGEXP
    static TQStringList split( const QRegExp &sep, const QString &str, bool allowEmptyEntries = FALSE );
#endif
    QString join( const QString &sep ) const;

    TQStringList grep( const QString &str, bool cs = TRUE ) const;
#ifndef TQT_NO_REGEXP
    TQStringList grep( const QRegExp &expr ) const;
#endif

    TQStringList& gres( const QString &before, const QString &after,
		       bool cs = TRUE );
#ifndef TQT_NO_REGEXP_CAPTURE
    TQStringList& gres( const QRegExp &expr, const QString &after );
#endif

protected:
    void detach() { TQValueList<QString>::detach(); }
    friend class QDeepCopy< TQStringList >;
};

#ifndef TQT_NO_DATASTREAM
class QDataStream;
extern QDataStream &operator>>( QDataStream &, TQStringList& );
extern QDataStream &operator<<( QDataStream &, const TQStringList& );
#endif

#endif

/**********************************************************************/

#endif // USE_QT4

#endif /* TQT_TQSTRINGLIST_H */
